/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.range;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.SortedNumericDocValues;
import conductor.org.elasticsearch.common.geo.GeoDistance;
import conductor.org.elasticsearch.common.geo.GeoPoint;
import conductor.org.elasticsearch.common.geo.GeoUtils;
import conductor.org.elasticsearch.common.unit.DistanceUnit;
import conductor.org.elasticsearch.index.fielddata.MultiGeoPointValues;
import conductor.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import conductor.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.bucket.range.GeoDistanceAggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.bucket.range.InternalGeoDistance;
import conductor.org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import conductor.org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class GeoDistanceRangeAggregatorFactory
extends ValuesSourceAggregatorFactory<ValuesSource.GeoPoint, GeoDistanceRangeAggregatorFactory> {
    private final InternalRange.Factory<InternalGeoDistance.Bucket, InternalGeoDistance> rangeFactory = InternalGeoDistance.FACTORY;
    private final GeoPoint origin;
    private final GeoDistanceAggregationBuilder.Range[] ranges;
    private final DistanceUnit unit;
    private final GeoDistance distanceType;
    private final boolean keyed;

    public GeoDistanceRangeAggregatorFactory(String name, ValuesSourceConfig<ValuesSource.GeoPoint> config, GeoPoint origin, GeoDistanceAggregationBuilder.Range[] ranges, DistanceUnit unit, GeoDistance distanceType, boolean keyed, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metaData);
        this.origin = origin;
        this.ranges = ranges;
        this.unit = unit;
        this.distanceType = distanceType;
        this.keyed = keyed;
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new RangeAggregator.Unmapped(this.name, (RangeAggregator.Range[])this.ranges, this.keyed, this.config.format(), this.context, parent, this.rangeFactory, pipelineAggregators, metaData);
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource.GeoPoint valuesSource, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        DistanceSource distanceSource = new DistanceSource(valuesSource, this.distanceType, this.origin, this.unit);
        return new RangeAggregator(this.name, this.factories, distanceSource, this.config.format(), this.rangeFactory, this.ranges, this.keyed, this.context, parent, pipelineAggregators, metaData);
    }

    private static class DistanceSource
    extends ValuesSource.Numeric {
        private final ValuesSource.GeoPoint source;
        private final GeoDistance distanceType;
        private final DistanceUnit units;
        private final GeoPoint origin;

        DistanceSource(ValuesSource.GeoPoint source, GeoDistance distanceType, GeoPoint origin, DistanceUnit units) {
            this.source = source;
            this.distanceType = distanceType;
            this.units = units;
            this.origin = origin;
        }

        @Override
        public boolean isFloatingPoint() {
            return true;
        }

        @Override
        public SortedNumericDocValues longValues(LeafReaderContext ctx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedNumericDoubleValues doubleValues(LeafReaderContext ctx) {
            MultiGeoPointValues geoValues = this.source.geoPointValues(ctx);
            return GeoUtils.distanceValues(this.distanceType, this.units, geoValues, this.origin);
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext ctx) {
            throw new UnsupportedOperationException();
        }
    }
}

