/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile;

import conductor.com.carrotsearch.hppc.DoubleArrayList;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.search.aggregations.AggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.BucketMetricsParser;
import conductor.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.BucketMetricsPipelineAggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile.PercentilesBucketPipelineAggregator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class PercentilesBucketPipelineAggregationBuilder
extends BucketMetricsPipelineAggregationBuilder<PercentilesBucketPipelineAggregationBuilder> {
    public static final String NAME = "percentiles_bucket";
    public static final ParseField PERCENTS_FIELD = new ParseField("percents", new String[0]);
    private double[] percents = new double[]{1.0, 5.0, 25.0, 50.0, 75.0, 95.0, 99.0};
    public static final PipelineAggregator.Parser PARSER = new BucketMetricsParser(){

        protected PercentilesBucketPipelineAggregationBuilder buildFactory(String pipelineAggregatorName, String bucketsPath, Map<String, Object> params) {
            PercentilesBucketPipelineAggregationBuilder factory = new PercentilesBucketPipelineAggregationBuilder(pipelineAggregatorName, bucketsPath);
            double[] percents = (double[])params.get(PERCENTS_FIELD.getPreferredName());
            if (percents != null) {
                factory.percents(percents);
            }
            return factory;
        }

        @Override
        protected boolean token(XContentParser parser, String field, XContentParser.Token token, Map<String, Object> params) throws IOException {
            if (PERCENTS_FIELD.match(field, parser.getDeprecationHandler()) && token == XContentParser.Token.START_ARRAY) {
                DoubleArrayList percents = new DoubleArrayList(10);
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    percents.add(parser.doubleValue());
                }
                params.put(PERCENTS_FIELD.getPreferredName(), percents.toArray());
                return true;
            }
            return false;
        }
    };

    public PercentilesBucketPipelineAggregationBuilder(String name, String bucketsPath) {
        super(name, NAME, new String[]{bucketsPath});
    }

    public PercentilesBucketPipelineAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME);
        this.percents = in.readDoubleArray();
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeDoubleArray(this.percents);
    }

    public double[] percents() {
        return this.percents;
    }

    public PercentilesBucketPipelineAggregationBuilder percents(double[] percents) {
        if (percents == null) {
            throw new IllegalArgumentException("[percents] must not be null: [" + this.name + "]");
        }
        double[] dArray = percents;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double p = dArray[i];
            if (p != null && !(p < 0.0) && !(p > 100.0)) continue;
            throw new IllegalArgumentException(PERCENTS_FIELD.getPreferredName() + " must only contain non-null doubles from 0.0-100.0 inclusive");
        }
        this.percents = percents;
        return this;
    }

    @Override
    protected PipelineAggregator createInternal(Map<String, Object> metaData) throws IOException {
        return new PercentilesBucketPipelineAggregator(this.name, this.percents, this.bucketsPaths, this.gapPolicy(), this.formatter(), metaData);
    }

    @Override
    public void doValidate(AggregatorFactory<?> parent, Collection<AggregationBuilder> aggFactories, Collection<PipelineAggregationBuilder> pipelineAggregatorFactories) {
        super.doValidate(parent, aggFactories, pipelineAggregatorFactories);
        double[] dArray = this.percents;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double p = dArray[i];
            if (p != null && !(p < 0.0) && !(p > 100.0)) continue;
            throw new IllegalStateException(PERCENTS_FIELD.getPreferredName() + " must only contain non-null doubles from 0.0-100.0 inclusive");
        }
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.percents != null) {
            builder.array(PERCENTS_FIELD.getPreferredName(), this.percents);
        }
        return builder;
    }

    @Override
    protected int innerHashCode() {
        return Arrays.hashCode(this.percents);
    }

    @Override
    protected boolean innerEquals(BucketMetricsPipelineAggregationBuilder<PercentilesBucketPipelineAggregationBuilder> obj) {
        PercentilesBucketPipelineAggregationBuilder other = (PercentilesBucketPipelineAggregationBuilder)obj;
        return Objects.deepEquals(this.percents, other.percents);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

