/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.pipeline.derivative;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.InternalAggregations;
import conductor.org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import conductor.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import conductor.org.elasticsearch.search.aggregations.bucket.histogram.HistogramFactory;
import conductor.org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.derivative.InternalDerivative;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class DerivativePipelineAggregator
extends PipelineAggregator {
    private final DocValueFormat formatter;
    private final BucketHelpers.GapPolicy gapPolicy;
    private final Double xAxisUnits;

    public DerivativePipelineAggregator(String name, String[] bucketsPaths, DocValueFormat formatter, BucketHelpers.GapPolicy gapPolicy, Long xAxisUnits, Map<String, Object> metadata) {
        super(name, bucketsPaths, metadata);
        this.formatter = formatter;
        this.gapPolicy = gapPolicy;
        this.xAxisUnits = xAxisUnits == null ? null : Double.valueOf(xAxisUnits.longValue());
    }

    public DerivativePipelineAggregator(StreamInput in) throws IOException {
        super(in);
        this.formatter = in.readNamedWriteable(DocValueFormat.class);
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
        this.xAxisUnits = in.readOptionalDouble();
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.formatter);
        this.gapPolicy.writeTo(out);
        out.writeOptionalDouble(this.xAxisUnits);
    }

    @Override
    public String getWriteableName() {
        return "derivative";
    }

    @Override
    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        InternalMultiBucketAggregation histo = (InternalMultiBucketAggregation)aggregation;
        List<InternalMultiBucketAggregation.InternalBucket> buckets = histo.getBuckets();
        HistogramFactory factory = (HistogramFactory)((Object)histo);
        ArrayList<MultiBucketsAggregation.Bucket> newBuckets = new ArrayList<MultiBucketsAggregation.Bucket>();
        Number lastBucketKey = null;
        Double lastBucketValue = null;
        for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
            Number thisBucketKey = factory.getKey(bucket);
            Double thisBucketValue = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)histo, bucket, this.bucketsPaths()[0], this.gapPolicy);
            if (lastBucketValue != null && thisBucketValue != null) {
                double gradient = thisBucketValue - lastBucketValue;
                double xDiff = -1.0;
                if (this.xAxisUnits != null) {
                    xDiff = (thisBucketKey.doubleValue() - lastBucketKey.doubleValue()) / this.xAxisUnits;
                }
                List<InternalAggregation> aggs = StreamSupport.stream(bucket.getAggregations().spliterator(), false).map(p -> (InternalAggregation)p).collect(Collectors.toList());
                aggs.add(new InternalDerivative(this.name(), gradient, xDiff, this.formatter, new ArrayList<PipelineAggregator>(), this.metaData()));
                MultiBucketsAggregation.Bucket newBucket = factory.createBucket(factory.getKey(bucket), bucket.getDocCount(), new InternalAggregations(aggs));
                newBuckets.add(newBucket);
            } else {
                newBuckets.add(bucket);
            }
            lastBucketKey = thisBucketKey;
            lastBucketValue = thisBucketValue;
        }
        return factory.createAggregation(newBuckets);
    }
}

