/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.collapse;

import conductor.org.apache.lucene.search.Sort;
import conductor.org.apache.lucene.search.grouping.CollapsingTopDocsCollector;
import conductor.org.elasticsearch.index.mapper.KeywordFieldMapper;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.mapper.NumberFieldMapper;
import conductor.org.elasticsearch.index.query.InnerHitBuilder;
import java.util.List;

public class CollapseContext {
    private final String fieldName;
    private final MappedFieldType fieldType;
    private final List<InnerHitBuilder> innerHits;

    public CollapseContext(String fieldName, MappedFieldType fieldType, List<InnerHitBuilder> innerHits) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.innerHits = innerHits;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public MappedFieldType getFieldType() {
        return this.fieldType;
    }

    public List<InnerHitBuilder> getInnerHit() {
        return this.innerHits;
    }

    public CollapsingTopDocsCollector<?> createTopDocs(Sort sort, int topN, boolean trackMaxScore) {
        if (this.fieldType instanceof KeywordFieldMapper.KeywordFieldType) {
            return CollapsingTopDocsCollector.createKeyword(this.fieldType.name(), sort, topN, trackMaxScore);
        }
        if (this.fieldType instanceof NumberFieldMapper.NumberFieldType) {
            return CollapsingTopDocsCollector.createNumeric(this.fieldType.name(), sort, topN, trackMaxScore);
        }
        throw new IllegalStateException("unknown type for collapse field " + this.fieldType.name() + ", only keywords and numbers are accepted");
    }
}

