/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.lookup;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.index.fielddata.IndexFieldData;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.mapper.MapperService;
import conductor.org.elasticsearch.search.lookup.DocLookup;
import conductor.org.elasticsearch.search.lookup.FieldsLookup;
import conductor.org.elasticsearch.search.lookup.LeafSearchLookup;
import conductor.org.elasticsearch.search.lookup.SourceLookup;
import java.util.function.Function;

public class SearchLookup {
    final DocLookup docMap;
    final SourceLookup sourceLookup;
    final FieldsLookup fieldsLookup;

    public SearchLookup(MapperService mapperService, Function<MappedFieldType, IndexFieldData<?>> fieldDataLookup, @Nullable String[] types) {
        this.docMap = new DocLookup(mapperService, fieldDataLookup, types);
        this.sourceLookup = new SourceLookup();
        this.fieldsLookup = new FieldsLookup(mapperService, types);
    }

    public LeafSearchLookup getLeafSearchLookup(LeafReaderContext context) {
        return new LeafSearchLookup(context, this.docMap.getLeafDocLookup(context), this.sourceLookup, this.fieldsLookup.getLeafFieldsLookup(context));
    }

    public DocLookup doc() {
        return this.docMap;
    }

    public SourceLookup source() {
        return this.sourceLookup;
    }
}

