/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.transport;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.common.breaker.CircuitBreaker;
import conductor.org.elasticsearch.common.breaker.NoopCircuitBreaker;
import conductor.org.elasticsearch.common.component.LifecycleComponent;
import conductor.org.elasticsearch.common.settings.Setting;
import conductor.org.elasticsearch.common.transport.BoundTransportAddress;
import conductor.org.elasticsearch.common.transport.TransportAddress;
import conductor.org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import conductor.org.elasticsearch.common.util.concurrent.ConcurrentMapLong;
import conductor.org.elasticsearch.transport.ConnectionProfile;
import conductor.org.elasticsearch.transport.RequestHandlerRegistry;
import conductor.org.elasticsearch.transport.TransportException;
import conductor.org.elasticsearch.transport.TransportMessageListener;
import conductor.org.elasticsearch.transport.TransportRequest;
import conductor.org.elasticsearch.transport.TransportRequestOptions;
import conductor.org.elasticsearch.transport.TransportResponse;
import conductor.org.elasticsearch.transport.TransportResponseHandler;
import conductor.org.elasticsearch.transport.TransportStats;
import java.io.Closeable;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;

public interface Transport
extends LifecycleComponent {
    public static final Setting<Boolean> TRANSPORT_TCP_COMPRESS = Setting.boolSetting("transport.tcp.compress", false, Setting.Property.NodeScope);

    public <Request extends TransportRequest> void registerRequestHandler(RequestHandlerRegistry<Request> var1);

    public RequestHandlerRegistry getRequestHandler(String var1);

    public void addMessageListener(TransportMessageListener var1);

    public boolean removeMessageListener(TransportMessageListener var1);

    public BoundTransportAddress boundAddress();

    public Map<String, BoundTransportAddress> profileBoundAddresses();

    public TransportAddress[] addressesFromString(String var1, int var2) throws UnknownHostException;

    public List<String> getLocalAddresses();

    default public CircuitBreaker getInFlightRequestBreaker() {
        return new NoopCircuitBreaker("in-flight-noop");
    }

    public Connection openConnection(DiscoveryNode var1, ConnectionProfile var2);

    public TransportStats getStats();

    public ResponseHandlers getResponseHandlers();

    public static final class ResponseHandlers {
        private final ConcurrentMapLong<ResponseContext> handlers = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
        private final AtomicLong requestIdGenerator = new AtomicLong();

        public boolean contains(long requestId) {
            return this.handlers.containsKey(requestId);
        }

        public ResponseContext remove(long requestId) {
            return this.handlers.remove(requestId);
        }

        public long add(ResponseContext holder) {
            long requestId = this.newRequestId();
            ResponseContext existing = this.handlers.put(requestId, holder);
            assert (existing == null) : "request ID already in use: " + requestId;
            return requestId;
        }

        long newRequestId() {
            return this.requestIdGenerator.incrementAndGet();
        }

        public List<ResponseContext> prune(Predicate<ResponseContext> predicate) {
            ArrayList<ResponseContext> holders = new ArrayList<ResponseContext>();
            for (Map.Entry entry : this.handlers.entrySet()) {
                ResponseContext remove;
                ResponseContext holder = (ResponseContext)entry.getValue();
                if (!predicate.test(holder) || (remove = (ResponseContext)this.handlers.remove(entry.getKey())) == null) continue;
                holders.add(holder);
            }
            return holders;
        }

        public TransportResponseHandler onResponseReceived(long requestId, TransportMessageListener listener) {
            ResponseContext context = this.handlers.remove(requestId);
            listener.onResponseReceived(requestId, context);
            if (context == null) {
                return null;
            }
            return context.handler();
        }
    }

    public static final class ResponseContext<T extends TransportResponse> {
        private final TransportResponseHandler<T> handler;
        private final Connection connection;
        private final String action;

        ResponseContext(TransportResponseHandler<T> handler, Connection connection, String action) {
            this.handler = handler;
            this.connection = connection;
            this.action = action;
        }

        public TransportResponseHandler<T> handler() {
            return this.handler;
        }

        public Connection connection() {
            return this.connection;
        }

        public String action() {
            return this.action;
        }
    }

    public static interface Connection
    extends Closeable {
        public DiscoveryNode getNode();

        public void sendRequest(long var1, String var3, TransportRequest var4, TransportRequestOptions var5) throws IOException, TransportException;

        default public boolean sendPing() {
            return false;
        }

        public void addCloseListener(ActionListener<Void> var1);

        public boolean isClosed();

        default public Version getVersion() {
            return this.getNode().getVersion();
        }

        default public Object getCacheKey() {
            return this;
        }

        @Override
        public void close();
    }
}

