/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.transport.netty4;

import conductor.io.netty.buffer.ByteBuf;
import conductor.io.netty.channel.ChannelHandlerContext;
import conductor.io.netty.handler.codec.ByteToMessageDecoder;
import conductor.io.netty.handler.codec.TooLongFrameException;
import conductor.org.elasticsearch.transport.TcpTransport;
import conductor.org.elasticsearch.transport.netty4.Netty4Utils;
import java.util.List;

final class Netty4SizeHeaderFrameDecoder
extends ByteToMessageDecoder {
    Netty4SizeHeaderFrameDecoder() {
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            boolean continueProcessing = TcpTransport.validateMessageHeader(Netty4Utils.toBytesReference(in));
            ByteBuf message = in.skipBytes(6);
            if (!continueProcessing) {
                return;
            }
            out.add(message);
        }
        catch (IllegalArgumentException ex) {
            throw new TooLongFrameException(ex);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

