/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.joda.time.convert;

import conductor.org.joda.time.Chronology;
import conductor.org.joda.time.DateTimeUtils;
import conductor.org.joda.time.DateTimeZone;
import conductor.org.joda.time.PeriodType;
import conductor.org.joda.time.ReadablePartial;
import conductor.org.joda.time.chrono.ISOChronology;
import conductor.org.joda.time.convert.Converter;
import conductor.org.joda.time.format.DateTimeFormatter;

public abstract class AbstractConverter
implements Converter {
    protected AbstractConverter() {
    }

    public long getInstantMillis(Object object, Chronology chronology) {
        return DateTimeUtils.currentTimeMillis();
    }

    public Chronology getChronology(Object object, DateTimeZone dateTimeZone) {
        return ISOChronology.getInstance(dateTimeZone);
    }

    public Chronology getChronology(Object object, Chronology chronology) {
        return DateTimeUtils.getChronology(chronology);
    }

    public int[] getPartialValues(ReadablePartial readablePartial, Object object, Chronology chronology) {
        long l = this.getInstantMillis(object, chronology);
        return chronology.get(readablePartial, l);
    }

    public int[] getPartialValues(ReadablePartial readablePartial, Object object, Chronology chronology, DateTimeFormatter dateTimeFormatter) {
        return this.getPartialValues(readablePartial, object, chronology);
    }

    public PeriodType getPeriodType(Object object) {
        return PeriodType.standard();
    }

    public boolean isReadableInterval(Object object, Chronology chronology) {
        return false;
    }

    public String toString() {
        return "Converter[" + (this.getSupportedType() == null ? "null" : this.getSupportedType().getName()) + "]";
    }
}

