/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.miscellaneous;

import conductor.org.apache.lucene.analysis.CharArraySet;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.miscellaneous.KeepWordFilter;
import conductor.org.apache.lucene.analysis.util.ResourceLoader;
import conductor.org.apache.lucene.analysis.util.ResourceLoaderAware;
import conductor.org.apache.lucene.analysis.util.TokenFilterFactory;
import java.io.IOException;
import java.util.Map;

public class KeepWordFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private final boolean ignoreCase;
    private final String wordFiles;
    private CharArraySet words;

    public KeepWordFilterFactory(Map<String, String> args) {
        super(args);
        this.wordFiles = this.get(args, "words");
        this.ignoreCase = this.getBoolean(args, "ignoreCase", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        if (this.wordFiles != null) {
            this.words = this.getWordSet(loader, this.wordFiles, this.ignoreCase);
        }
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public CharArraySet getWords() {
        return this.words;
    }

    @Override
    public TokenStream create(TokenStream input) {
        if (this.words == null) {
            return input;
        }
        KeepWordFilter filter = new KeepWordFilter(input, this.words);
        return filter;
    }
}

