/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.queryparser.surround.query;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.queryparser.surround.query.BasicQueryFactory;
import conductor.org.apache.lucene.queryparser.surround.query.ComposedQuery;
import conductor.org.apache.lucene.queryparser.surround.query.DistanceRewriteQuery;
import conductor.org.apache.lucene.queryparser.surround.query.DistanceSubQuery;
import conductor.org.apache.lucene.queryparser.surround.query.SpanNearClauseFactory;
import conductor.org.apache.lucene.queryparser.surround.query.SrndQuery;
import conductor.org.apache.lucene.search.MatchNoDocsQuery;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.spans.SpanNearQuery;
import conductor.org.apache.lucene.search.spans.SpanQuery;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class DistanceQuery
extends ComposedQuery
implements DistanceSubQuery {
    private int opDistance;
    private boolean ordered;

    public DistanceQuery(List<SrndQuery> queries, boolean infix, int opDistance, String opName, boolean ordered) {
        super(queries, infix, opName);
        this.opDistance = opDistance;
        this.ordered = ordered;
    }

    public int getOpDistance() {
        return this.opDistance;
    }

    public boolean subQueriesOrdered() {
        return this.ordered;
    }

    @Override
    public String distanceSubQueryNotAllowed() {
        Iterator<SrndQuery> sqi = this.getSubQueriesIterator();
        while (sqi.hasNext()) {
            SrndQuery leq = sqi.next();
            if (leq instanceof DistanceSubQuery) {
                DistanceSubQuery dsq = (DistanceSubQuery)((Object)leq);
                String m = dsq.distanceSubQueryNotAllowed();
                if (m == null) continue;
                return m;
            }
            return "Operator " + this.getOperatorName() + " does not allow subquery " + ((Object)leq).toString();
        }
        return null;
    }

    @Override
    public void addSpanQueries(SpanNearClauseFactory sncf) throws IOException {
        Query snq = this.getSpanNearQuery(sncf.getIndexReader(), sncf.getFieldName(), sncf.getBasicQueryFactory());
        sncf.addSpanQuery(snq);
    }

    public Query getSpanNearQuery(IndexReader reader, String fieldName, BasicQueryFactory qf) throws IOException {
        SpanQuery[] spanClauses = new SpanQuery[this.getNrSubQueries()];
        Iterator<SrndQuery> sqi = this.getSubQueriesIterator();
        int qi = 0;
        while (sqi.hasNext()) {
            SpanNearClauseFactory sncf = new SpanNearClauseFactory(reader, fieldName, qf);
            ((DistanceSubQuery)((Object)sqi.next())).addSpanQueries(sncf);
            if (sncf.size() == 0) {
                while (sqi.hasNext()) {
                    ((DistanceSubQuery)((Object)sqi.next())).addSpanQueries(sncf);
                    sncf.clear();
                }
                return new MatchNoDocsQuery();
            }
            spanClauses[qi] = sncf.makeSpanClause();
            ++qi;
        }
        return new SpanNearQuery(spanClauses, this.getOpDistance() - 1, this.subQueriesOrdered());
    }

    @Override
    public Query makeLuceneQueryFieldNoBoost(String fieldName, BasicQueryFactory qf) {
        return new DistanceRewriteQuery(this, fieldName, qf);
    }
}

