/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action;

import conductor.org.elasticsearch.action.IndicesRequest;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import java.io.IOException;
import java.util.Arrays;

public final class OriginalIndices
implements IndicesRequest {
    public static final OriginalIndices NONE = new OriginalIndices(null, null);
    private final String[] indices;
    private final IndicesOptions indicesOptions;

    public OriginalIndices(IndicesRequest indicesRequest) {
        this(indicesRequest.indices(), indicesRequest.indicesOptions());
    }

    public OriginalIndices(String[] indices, IndicesOptions indicesOptions) {
        this.indices = indices;
        this.indicesOptions = indicesOptions;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public static OriginalIndices readOriginalIndices(StreamInput in) throws IOException {
        return new OriginalIndices(in.readStringArray(), IndicesOptions.readIndicesOptions(in));
    }

    public static void writeOriginalIndices(OriginalIndices originalIndices, StreamOutput out) throws IOException {
        assert (originalIndices != NONE);
        out.writeStringArrayNullable(originalIndices.indices);
        originalIndices.indicesOptions.writeIndicesOptions(out);
    }

    public String toString() {
        return "OriginalIndices{indices=" + Arrays.toString(this.indices) + ", indicesOptions=" + this.indicesOptions + '}';
    }
}

