/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.shards;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsGroup;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.search.internal.AliasFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ClusterSearchShardsResponse
extends ActionResponse
implements ToXContentObject {
    public static final ClusterSearchShardsResponse EMPTY = new ClusterSearchShardsResponse(new ClusterSearchShardsGroup[0], new DiscoveryNode[0], Collections.emptyMap());
    private ClusterSearchShardsGroup[] groups;
    private DiscoveryNode[] nodes;
    private Map<String, AliasFilter> indicesAndFilters;

    public ClusterSearchShardsResponse() {
    }

    public ClusterSearchShardsResponse(ClusterSearchShardsGroup[] groups, DiscoveryNode[] nodes, Map<String, AliasFilter> indicesAndFilters) {
        this.groups = groups;
        this.nodes = nodes;
        this.indicesAndFilters = indicesAndFilters;
    }

    public ClusterSearchShardsGroup[] getGroups() {
        return this.groups;
    }

    public DiscoveryNode[] getNodes() {
        return this.nodes;
    }

    public Map<String, AliasFilter> getIndicesAndFilters() {
        return this.indicesAndFilters;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        super.readFrom(in);
        this.groups = new ClusterSearchShardsGroup[in.readVInt()];
        for (i = 0; i < this.groups.length; ++i) {
            this.groups[i] = ClusterSearchShardsGroup.readSearchShardsGroupResponse(in);
        }
        this.nodes = new DiscoveryNode[in.readVInt()];
        for (i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = new DiscoveryNode(in);
        }
        if (in.getVersion().onOrAfter(Version.V_5_1_1)) {
            int size = in.readVInt();
            this.indicesAndFilters = new HashMap<String, AliasFilter>();
            for (int i2 = 0; i2 < size; ++i2) {
                String index = in.readString();
                AliasFilter aliasFilter = new AliasFilter(in);
                this.indicesAndFilters.put(index, aliasFilter);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.groups.length);
        for (ClusterSearchShardsGroup clusterSearchShardsGroup : this.groups) {
            clusterSearchShardsGroup.writeTo(out);
        }
        out.writeVInt(this.nodes.length);
        for (ToXContent toXContent : this.nodes) {
            ((DiscoveryNode)toXContent).writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_5_1_1)) {
            out.writeVInt(this.indicesAndFilters.size());
            for (Map.Entry entry : this.indicesAndFilters.entrySet()) {
                out.writeString((String)entry.getKey());
                ((AliasFilter)entry.getValue()).writeTo(out);
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("nodes");
        for (DiscoveryNode node : this.nodes) {
            node.toXContent(builder, params);
        }
        builder.endObject();
        if (this.indicesAndFilters != null) {
            builder.startObject("indices");
            for (Map.Entry entry : this.indicesAndFilters.entrySet()) {
                String index = (String)entry.getKey();
                builder.startObject(index);
                AliasFilter aliasFilter = (AliasFilter)entry.getValue();
                Object[] aliases = aliasFilter.getAliases();
                if (aliases.length > 0) {
                    Arrays.sort(aliases);
                    builder.array("aliases", (String[])aliases);
                    if (aliasFilter.getQueryBuilder() != null) {
                        builder.field("filter");
                        aliasFilter.getQueryBuilder().toXContent(builder, params);
                    }
                }
                builder.endObject();
            }
            builder.endObject();
        }
        builder.startArray("shards");
        for (ClusterSearchShardsGroup group : this.groups) {
            group.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }
}

