/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.indices.validate.query;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Streamable;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import java.io.IOException;
import java.util.Objects;

public class QueryExplanation
implements Streamable,
ToXContentFragment {
    public static final String INDEX_FIELD = "index";
    public static final String SHARD_FIELD = "shard";
    public static final String VALID_FIELD = "valid";
    public static final String ERROR_FIELD = "error";
    public static final String EXPLANATION_FIELD = "explanation";
    public static final int RANDOM_SHARD = -1;
    static ConstructingObjectParser<QueryExplanation, Void> PARSER = new ConstructingObjectParser("query_explanation", true, a -> {
        int shard = -1;
        if (a[1] != null) {
            shard = (Integer)a[1];
        }
        return new QueryExplanation((String)a[0], shard, (Boolean)a[2], (String)a[3], (String)a[4]);
    });
    private String index;
    private int shard = -1;
    private boolean valid;
    private String explanation;
    private String error;

    QueryExplanation() {
    }

    public QueryExplanation(String index, int shard, boolean valid, String explanation, String error) {
        this.index = index;
        this.shard = shard;
        this.valid = valid;
        this.explanation = explanation;
        this.error = error;
    }

    public String getIndex() {
        return this.index;
    }

    public int getShard() {
        return this.shard;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getError() {
        return this.error;
    }

    public String getExplanation() {
        return this.explanation;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.index = in.getVersion().onOrAfter(Version.V_6_4_0) ? in.readOptionalString() : in.readString();
        this.shard = in.getVersion().onOrAfter(Version.V_5_4_0) ? in.readInt() : -1;
        this.valid = in.readBoolean();
        this.explanation = in.readOptionalString();
        this.error = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeOptionalString(this.index);
        } else {
            out.writeString(this.index);
        }
        if (out.getVersion().onOrAfter(Version.V_5_4_0)) {
            out.writeInt(this.shard);
        }
        out.writeBoolean(this.valid);
        out.writeOptionalString(this.explanation);
        out.writeOptionalString(this.error);
    }

    public static QueryExplanation readQueryExplanation(StreamInput in) throws IOException {
        QueryExplanation exp = new QueryExplanation();
        exp.readFrom(in);
        return exp;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.getIndex() != null) {
            builder.field(INDEX_FIELD, this.getIndex());
        }
        if (this.getShard() >= 0) {
            builder.field(SHARD_FIELD, this.getShard());
        }
        builder.field(VALID_FIELD, this.isValid());
        if (this.getError() != null) {
            builder.field(ERROR_FIELD, this.getError());
        }
        if (this.getExplanation() != null) {
            builder.field(EXPLANATION_FIELD, this.getExplanation());
        }
        return builder;
    }

    public static QueryExplanation fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryExplanation other = (QueryExplanation)o;
        return Objects.equals(this.getIndex(), other.getIndex()) && Objects.equals(this.getShard(), other.getShard()) && Objects.equals(this.isValid(), other.isValid()) && Objects.equals(this.getError(), other.getError()) && Objects.equals(this.getExplanation(), other.getExplanation());
    }

    public int hashCode() {
        return Objects.hash(this.getIndex(), this.getShard(), this.isValid(), this.getError(), this.getExplanation());
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(INDEX_FIELD, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField(SHARD_FIELD, new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField(VALID_FIELD, new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(EXPLANATION_FIELD, new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(ERROR_FIELD, new String[0]));
    }
}

