/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.bulk;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.action.DocWriteRequest;
import conductor.org.elasticsearch.action.DocWriteResponse;
import conductor.org.elasticsearch.action.bulk.BulkAction;
import conductor.org.elasticsearch.action.bulk.BulkItemRequest;
import conductor.org.elasticsearch.action.bulk.BulkItemResponse;
import conductor.org.elasticsearch.action.bulk.BulkPrimaryExecutionContext;
import conductor.org.elasticsearch.action.bulk.BulkShardRequest;
import conductor.org.elasticsearch.action.bulk.BulkShardResponse;
import conductor.org.elasticsearch.action.bulk.MappingUpdatePerformer;
import conductor.org.elasticsearch.action.delete.DeleteRequest;
import conductor.org.elasticsearch.action.delete.DeleteResponse;
import conductor.org.elasticsearch.action.index.IndexRequest;
import conductor.org.elasticsearch.action.index.IndexResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.PlainActionFuture;
import conductor.org.elasticsearch.action.support.replication.TransportReplicationAction;
import conductor.org.elasticsearch.action.support.replication.TransportWriteAction;
import conductor.org.elasticsearch.action.update.UpdateHelper;
import conductor.org.elasticsearch.action.update.UpdateRequest;
import conductor.org.elasticsearch.action.update.UpdateResponse;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.ClusterStateObserver;
import conductor.org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import conductor.org.elasticsearch.cluster.action.shard.ShardStateAction;
import conductor.org.elasticsearch.cluster.metadata.IndexMetaData;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.metadata.MappingMetaData;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.CheckedRunnable;
import conductor.org.elasticsearch.common.CheckedSupplier;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.collect.Tuple;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.xcontent.XContentHelper;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import conductor.org.elasticsearch.index.engine.Engine;
import conductor.org.elasticsearch.index.engine.VersionConflictEngineException;
import conductor.org.elasticsearch.index.get.GetResult;
import conductor.org.elasticsearch.index.mapper.MapperException;
import conductor.org.elasticsearch.index.mapper.Mapping;
import conductor.org.elasticsearch.index.mapper.SourceToParse;
import conductor.org.elasticsearch.index.shard.IndexShard;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.index.translog.Translog;
import conductor.org.elasticsearch.indices.IndicesService;
import conductor.org.elasticsearch.node.NodeClosedException;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportRequestOptions;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;

public class TransportShardBulkAction
extends TransportWriteAction<BulkShardRequest, BulkShardRequest, BulkShardResponse> {
    public static final String ACTION_NAME = "indices:data/write/bulk[s]";
    private static final Logger logger = LogManager.getLogger(TransportShardBulkAction.class);
    private final UpdateHelper updateHelper;
    private final MappingUpdatedAction mappingUpdatedAction;

    @Inject
    public TransportShardBulkAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, MappingUpdatedAction mappingUpdatedAction, UpdateHelper updateHelper, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, indexNameExpressionResolver, BulkShardRequest::new, BulkShardRequest::new, "write");
        this.updateHelper = updateHelper;
        this.mappingUpdatedAction = mappingUpdatedAction;
    }

    @Override
    protected TransportRequestOptions transportOptions() {
        return BulkAction.INSTANCE.transportOptions(this.settings);
    }

    @Override
    protected BulkShardResponse newResponseInstance() {
        return new BulkShardResponse();
    }

    @Override
    protected boolean resolveIndex() {
        return false;
    }

    @Override
    protected TransportWriteAction.WritePrimaryResult<BulkShardRequest, BulkShardResponse> shardOperationOnPrimary(BulkShardRequest request, IndexShard primary) throws Exception {
        ClusterStateObserver observer = new ClusterStateObserver(this.clusterService, request.timeout(), logger, this.threadPool.getThreadContext());
        CheckedRunnable<Exception> waitForMappingUpdate = () -> {
            final PlainActionFuture waitingFuture = new PlainActionFuture();
            observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    waitingFuture.onResponse(null);
                }

                @Override
                public void onClusterServiceClose() {
                    waitingFuture.onFailure(new NodeClosedException(TransportShardBulkAction.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    waitingFuture.onFailure(new MapperException("timed out while waiting for a dynamic mapping update"));
                }
            });
            waitingFuture.get();
        };
        return TransportShardBulkAction.performOnPrimary(request, primary, this.updateHelper, this.threadPool::absoluteTimeInMillis, new ConcreteMappingUpdatePerformer(), waitForMappingUpdate);
    }

    public static TransportWriteAction.WritePrimaryResult<BulkShardRequest, BulkShardResponse> performOnPrimary(BulkShardRequest request, IndexShard primary, UpdateHelper updateHelper, LongSupplier nowInMillisSupplier, MappingUpdatePerformer mappingUpdater, CheckedRunnable<Exception> waitForMappingUpdate) throws Exception {
        BulkPrimaryExecutionContext context = new BulkPrimaryExecutionContext(request, primary);
        return TransportShardBulkAction.performOnPrimary(context, updateHelper, nowInMillisSupplier, mappingUpdater, waitForMappingUpdate);
    }

    private static TransportWriteAction.WritePrimaryResult<BulkShardRequest, BulkShardResponse> performOnPrimary(BulkPrimaryExecutionContext context, UpdateHelper updateHelper, LongSupplier nowInMillisSupplier, MappingUpdatePerformer mappingUpdater, CheckedRunnable<Exception> waitForMappingUpdate) throws Exception {
        while (context.hasMoreOperationsToExecute()) {
            TransportShardBulkAction.executeBulkItemRequest(context, updateHelper, nowInMillisSupplier, mappingUpdater, waitForMappingUpdate);
            assert (context.isInitial());
        }
        return new TransportWriteAction.WritePrimaryResult<BulkShardRequest, BulkShardResponse>(context.getBulkShardRequest(), context.buildShardResponse(), context.getLocationToSync(), null, context.getPrimary(), logger);
    }

    static void executeBulkItemRequest(BulkPrimaryExecutionContext context, UpdateHelper updateHelper, LongSupplier nowInMillisSupplier, MappingUpdatePerformer mappingUpdater, CheckedRunnable<Exception> waitForMappingUpdate) throws Exception {
        UpdateHelper.Result updateResult;
        UpdateRequest updateRequest;
        DocWriteRequest.OpType opType = context.getCurrent().opType();
        if (opType == DocWriteRequest.OpType.UPDATE) {
            updateRequest = (UpdateRequest)context.getCurrent();
            try {
                updateResult = updateHelper.prepare(updateRequest, context.getPrimary(), nowInMillisSupplier);
            }
            catch (Exception failure) {
                Engine.IndexResult result = new Engine.IndexResult(failure, updateRequest.version(), -2L);
                context.setRequestToExecute(updateRequest);
                context.markOperationAsExecuted(result);
                context.markAsCompleted(context.getExecutionResult());
                return;
            }
            switch (updateResult.getResponseResult()) {
                case CREATED: 
                case UPDATED: {
                    IndexRequest indexRequest = (IndexRequest)updateResult.action();
                    IndexMetaData metaData = context.getPrimary().indexSettings().getIndexMetaData();
                    MappingMetaData mappingMd = metaData.mappingOrDefault(indexRequest.type());
                    indexRequest.process(metaData.getCreationVersion(), mappingMd, updateRequest.concreteIndex());
                    context.setRequestToExecute(indexRequest);
                    break;
                }
                case DELETED: {
                    context.setRequestToExecute((DocWriteRequest)updateResult.action());
                    break;
                }
                case NOOP: {
                    context.markOperationAsNoOp((DocWriteResponse)updateResult.action());
                    context.markAsCompleted(context.getExecutionResult());
                    return;
                }
                default: {
                    throw new IllegalStateException("Illegal update operation " + updateResult.getResponseResult());
                }
            }
        } else {
            context.setRequestToExecute(context.getCurrent());
            updateResult = null;
        }
        assert (context.getRequestToExecute() != null);
        if (context.getRequestToExecute().opType() == DocWriteRequest.OpType.DELETE) {
            TransportShardBulkAction.executeDeleteRequestOnPrimary(context, mappingUpdater);
        } else {
            TransportShardBulkAction.executeIndexRequestOnPrimary(context, mappingUpdater);
        }
        if (context.requiresWaitingForMappingUpdate()) {
            try {
                waitForMappingUpdate.run();
                context.resetForExecutionForRetry();
            }
            catch (Exception e) {
                context.failOnMappingUpdate(e);
            }
            return;
        }
        assert (context.isOperationExecuted());
        if (opType == DocWriteRequest.OpType.UPDATE && context.getExecutionResult().isFailed() && TransportShardBulkAction.isConflictException(context.getExecutionResult().getFailure().getCause())) {
            updateRequest = (UpdateRequest)context.getCurrent();
            if (context.getRetryCounter() < updateRequest.retryOnConflict()) {
                context.resetForExecutionForRetry();
                return;
            }
        }
        TransportShardBulkAction.finalizePrimaryOperationOnCompletion(context, opType, updateResult);
    }

    private static void finalizePrimaryOperationOnCompletion(BulkPrimaryExecutionContext context, DocWriteRequest.OpType opType, UpdateHelper.Result updateResult) {
        BulkItemResponse executionResult = context.getExecutionResult();
        if (opType == DocWriteRequest.OpType.UPDATE) {
            UpdateRequest updateRequest = (UpdateRequest)context.getCurrent();
            context.markAsCompleted(TransportShardBulkAction.processUpdateResponse(updateRequest, context.getConcreteIndex(), executionResult, updateResult));
        } else if (executionResult.isFailed()) {
            Exception failure = executionResult.getFailure().getCause();
            DocWriteRequest<?> docWriteRequest = context.getCurrent();
            if (TransportShardBulkAction.isConflictException(failure)) {
                logger.trace(() -> new ParameterizedMessage("{} failed to execute bulk item ({}) {}", context.getPrimary().shardId(), docWriteRequest.opType().getLowercase(), docWriteRequest), (Throwable)failure);
            } else {
                logger.debug(() -> new ParameterizedMessage("{} failed to execute bulk item ({}) {}", context.getPrimary().shardId(), docWriteRequest.opType().getLowercase(), docWriteRequest), (Throwable)failure);
            }
            BulkItemResponse primaryResponse = TransportShardBulkAction.isConflictException(failure) && context.getPreviousPrimaryResponse() != null ? context.getPreviousPrimaryResponse() : executionResult;
            context.markAsCompleted(primaryResponse);
        } else {
            context.markAsCompleted(executionResult);
        }
        assert (context.isInitial());
    }

    private static boolean isConflictException(Exception e) {
        return ExceptionsHelper.unwrapCause(e) instanceof VersionConflictEngineException;
    }

    static BulkItemResponse processUpdateResponse(UpdateRequest updateRequest, String concreteIndex, BulkItemResponse operationResponse, UpdateHelper.Result translate) {
        BulkItemResponse response;
        DocWriteResponse.Result translatedResult = translate.getResponseResult();
        if (operationResponse.isFailed()) {
            response = new BulkItemResponse(operationResponse.getItemId(), DocWriteRequest.OpType.UPDATE, operationResponse.getFailure());
        } else {
            UpdateResponse updateResponse;
            if (translatedResult == DocWriteResponse.Result.CREATED || translatedResult == DocWriteResponse.Result.UPDATED) {
                IndexRequest updateIndexRequest = (IndexRequest)translate.action();
                IndexResponse indexResponse = (IndexResponse)operationResponse.getResponse();
                updateResponse = new UpdateResponse(indexResponse.getShardInfo(), indexResponse.getShardId(), indexResponse.getType(), indexResponse.getId(), indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), indexResponse.getVersion(), indexResponse.getResult());
                if (updateRequest.fetchSource() != null && updateRequest.fetchSource().fetchSource() || updateRequest.fields() != null && updateRequest.fields().length > 0) {
                    BytesReference indexSourceAsBytes = updateIndexRequest.source();
                    Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(indexSourceAsBytes, true, updateIndexRequest.getContentType());
                    updateResponse.setGetResult(UpdateHelper.extractGetResult(updateRequest, concreteIndex, indexResponse.getVersion(), sourceAndContent.v2(), sourceAndContent.v1(), indexSourceAsBytes));
                }
            } else if (translatedResult == DocWriteResponse.Result.DELETED) {
                DeleteResponse deleteResponse = (DeleteResponse)operationResponse.getResponse();
                updateResponse = new UpdateResponse(deleteResponse.getShardInfo(), deleteResponse.getShardId(), deleteResponse.getType(), deleteResponse.getId(), deleteResponse.getSeqNo(), deleteResponse.getPrimaryTerm(), deleteResponse.getVersion(), deleteResponse.getResult());
                GetResult getResult = UpdateHelper.extractGetResult(updateRequest, concreteIndex, deleteResponse.getVersion(), translate.updatedSourceAsMap(), translate.updateSourceContentType(), null);
                updateResponse.setGetResult(getResult);
            } else {
                throw new IllegalArgumentException("unknown operation type: " + translatedResult);
            }
            response = new BulkItemResponse(operationResponse.getItemId(), DocWriteRequest.OpType.UPDATE, updateResponse);
        }
        return response;
    }

    static ReplicaItemExecutionMode replicaItemExecutionMode(BulkItemRequest request, int index) {
        BulkItemResponse primaryResponse = request.getPrimaryResponse();
        assert (primaryResponse != null) : "expected primary response to be set for item [" + index + "] request [" + request.request() + "]";
        if (primaryResponse.isFailed()) {
            return primaryResponse.getFailure().getSeqNo() != -2L ? ReplicaItemExecutionMode.FAILURE : ReplicaItemExecutionMode.NOOP;
        }
        return ((DocWriteResponse)primaryResponse.getResponse()).getResult() != DocWriteResponse.Result.NOOP ? ReplicaItemExecutionMode.NORMAL : ReplicaItemExecutionMode.NOOP;
    }

    @Override
    public TransportWriteAction.WriteReplicaResult<BulkShardRequest> shardOperationOnReplica(BulkShardRequest request, IndexShard replica) throws Exception {
        Translog.Location location = TransportShardBulkAction.performOnReplica(request, replica);
        return new TransportWriteAction.WriteReplicaResult<BulkShardRequest>(request, location, null, replica, logger);
    }

    public static Translog.Location performOnReplica(BulkShardRequest request, IndexShard replica) throws Exception {
        Translog.Location location = null;
        block5: for (int i = 0; i < request.items().length; ++i) {
            BulkItemRequest item = request.items()[i];
            DocWriteRequest docWriteRequest = item.request();
            switch (TransportShardBulkAction.replicaItemExecutionMode(item, i)) {
                case NORMAL: {
                    Object primaryResponse = item.getPrimaryResponse().getResponse();
                    Engine.Result operationResult = TransportShardBulkAction.performOpOnReplica(primaryResponse, docWriteRequest, replica);
                    assert (operationResult != null) : "operation result must never be null when primary response has no failure";
                    location = TransportShardBulkAction.syncOperationResultOrThrow(operationResult, location);
                    continue block5;
                }
                case NOOP: {
                    continue block5;
                }
                case FAILURE: {
                    BulkItemResponse.Failure failure = item.getPrimaryResponse().getFailure();
                    assert (failure.getSeqNo() != -2L) : "seq no must be assigned";
                    Engine.Result operationResult = replica.markSeqNoAsNoop(failure.getSeqNo(), failure.getMessage());
                    assert (operationResult != null) : "operation result must never be null when primary response has no failure";
                    location = TransportShardBulkAction.syncOperationResultOrThrow(operationResult, location);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("illegal replica item execution mode for: " + docWriteRequest);
                }
            }
        }
        return location;
    }

    private static Engine.Result performOpOnReplica(DocWriteResponse primaryResponse, DocWriteRequest docWriteRequest, IndexShard replica) throws Exception {
        Engine.Result result;
        switch (docWriteRequest.opType()) {
            case CREATE: 
            case INDEX: {
                IndexRequest indexRequest = (IndexRequest)docWriteRequest;
                ShardId shardId = replica.shardId();
                SourceToParse sourceToParse = SourceToParse.source(shardId.getIndexName(), indexRequest.type(), indexRequest.id(), indexRequest.source(), indexRequest.getContentType()).routing(indexRequest.routing()).parent(indexRequest.parent());
                result = replica.applyIndexOperationOnReplica(primaryResponse.getSeqNo(), primaryResponse.getVersion(), indexRequest.versionType().versionTypeForReplicationAndRecovery(), indexRequest.getAutoGeneratedTimestamp(), indexRequest.isRetry(), sourceToParse);
                break;
            }
            case DELETE: {
                DeleteRequest deleteRequest = (DeleteRequest)docWriteRequest;
                result = replica.applyDeleteOperationOnReplica(primaryResponse.getSeqNo(), primaryResponse.getVersion(), deleteRequest.type(), deleteRequest.id(), deleteRequest.versionType().versionTypeForReplicationAndRecovery());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected request operation type on replica: " + docWriteRequest.opType().getLowercase());
            }
        }
        if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
            throw new TransportReplicationAction.RetryOnReplicaException(replica.shardId(), "Mappings are not available on the replica yet, triggered update: " + result.getRequiredMappingUpdate());
        }
        return result;
    }

    private static void executeIndexRequestOnPrimary(BulkPrimaryExecutionContext context, MappingUpdatePerformer mappingUpdater) throws Exception {
        IndexRequest request = (IndexRequest)context.getRequestToExecute();
        IndexShard primary = context.getPrimary();
        SourceToParse sourceToParse = SourceToParse.source(request.index(), request.type(), request.id(), request.source(), request.getContentType()).routing(request.routing()).parent(request.parent());
        TransportShardBulkAction.executeOnPrimaryWhileHandlingMappingUpdates(context, () -> primary.applyIndexOperationOnPrimary(request.version(), request.versionType(), sourceToParse, request.getAutoGeneratedTimestamp(), request.isRetry()), e -> primary.getFailedIndexResult((Exception)e, request.version()), context::markOperationAsExecuted, mapping -> mappingUpdater.updateMappings((Mapping)mapping, primary.shardId(), request.type()));
    }

    private static void executeDeleteRequestOnPrimary(BulkPrimaryExecutionContext context, MappingUpdatePerformer mappingUpdater) throws Exception {
        DeleteRequest request = (DeleteRequest)context.getRequestToExecute();
        IndexShard primary = context.getPrimary();
        TransportShardBulkAction.executeOnPrimaryWhileHandlingMappingUpdates(context, () -> primary.applyDeleteOperationOnPrimary(request.version(), request.type(), request.id(), request.versionType()), e -> primary.getFailedDeleteResult((Exception)e, request.version()), context::markOperationAsExecuted, mapping -> mappingUpdater.updateMappings((Mapping)mapping, primary.shardId(), request.type()));
    }

    private static <T extends Engine.Result> void executeOnPrimaryWhileHandlingMappingUpdates(BulkPrimaryExecutionContext context, CheckedSupplier<T, IOException> toExecute, Function<Exception, T> exceptionToResult, Consumer<T> onComplete, Consumer<Mapping> mappingUpdater) throws IOException {
        Engine.Result result = (Engine.Result)toExecute.get();
        if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
            try {
                mappingUpdater.accept(result.getRequiredMappingUpdate());
            }
            catch (Exception e) {
                onComplete.accept((Engine.Result)exceptionToResult.apply(e));
                return;
            }
            result = (Engine.Result)toExecute.get();
            if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
                context.markAsRequiringMappingUpdate();
            } else {
                onComplete.accept(result);
            }
        } else {
            onComplete.accept(result);
        }
    }

    class ConcreteMappingUpdatePerformer
    implements MappingUpdatePerformer {
        ConcreteMappingUpdatePerformer() {
        }

        @Override
        public void updateMappings(Mapping update, ShardId shardId, String type) {
            assert (update != null);
            assert (shardId != null);
            TransportShardBulkAction.this.mappingUpdatedAction.updateMappingOnMaster(shardId.getIndex(), type, update);
        }
    }

    public static enum ReplicaItemExecutionMode {
        NORMAL,
        NOOP,
        FAILURE;

    }
}

