/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.ingest;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.ActionRunnable;
import conductor.org.elasticsearch.action.ingest.SimulateDocumentBaseResult;
import conductor.org.elasticsearch.action.ingest.SimulateDocumentResult;
import conductor.org.elasticsearch.action.ingest.SimulateDocumentVerboseResult;
import conductor.org.elasticsearch.action.ingest.SimulatePipelineRequest;
import conductor.org.elasticsearch.action.ingest.SimulatePipelineResponse;
import conductor.org.elasticsearch.action.ingest.SimulateProcessorResult;
import conductor.org.elasticsearch.ingest.CompoundProcessor;
import conductor.org.elasticsearch.ingest.IngestDocument;
import conductor.org.elasticsearch.ingest.Pipeline;
import conductor.org.elasticsearch.ingest.TrackingResultProcessor;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import java.util.ArrayList;

class SimulateExecutionService {
    private static final String THREAD_POOL_NAME = "management";
    private final ThreadPool threadPool;

    SimulateExecutionService(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    SimulateDocumentResult executeDocument(Pipeline pipeline, IngestDocument ingestDocument, boolean verbose) {
        if (verbose) {
            ArrayList<SimulateProcessorResult> processorResultList = new ArrayList<SimulateProcessorResult>();
            CompoundProcessor verbosePipelineProcessor = TrackingResultProcessor.decorate(pipeline.getCompoundProcessor(), processorResultList);
            try {
                Pipeline verbosePipeline = new Pipeline(pipeline.getId(), pipeline.getDescription(), pipeline.getVersion(), verbosePipelineProcessor);
                ingestDocument.executePipeline(verbosePipeline);
                return new SimulateDocumentVerboseResult(processorResultList);
            }
            catch (Exception e) {
                return new SimulateDocumentVerboseResult(processorResultList);
            }
        }
        try {
            pipeline.execute(ingestDocument);
            return new SimulateDocumentBaseResult(ingestDocument);
        }
        catch (Exception e) {
            return new SimulateDocumentBaseResult(e);
        }
    }

    public void execute(final SimulatePipelineRequest.Parsed request, ActionListener<SimulatePipelineResponse> listener) {
        this.threadPool.executor(THREAD_POOL_NAME).execute(new ActionRunnable<SimulatePipelineResponse>(listener){

            @Override
            protected void doRun() throws Exception {
                ArrayList<SimulateDocumentResult> responses = new ArrayList<SimulateDocumentResult>();
                for (IngestDocument ingestDocument : request.getDocuments()) {
                    SimulateDocumentResult response = SimulateExecutionService.this.executeDocument(request.getPipeline(), ingestDocument, request.isVerbose());
                    if (response == null) continue;
                    responses.add(response);
                }
                this.listener.onResponse(new SimulatePipelineResponse(request.getPipeline().getId(), request.isVerbose(), responses));
            }
        });
    }
}

