/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.admin.indices;

import conductor.org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.action.support.master.AcknowledgedResponse;
import conductor.org.elasticsearch.client.Requests;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.action.RestToXContentListener;
import java.io.IOException;
import java.util.Set;

public class RestUpdateSettingsAction
extends BaseRestHandler {
    public RestUpdateSettingsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_settings", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_settings", this);
    }

    @Override
    public String getName() {
        return "update_settings_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        UpdateSettingsRequest updateSettingsRequest = Requests.updateSettingsRequest(Strings.splitStringByCommaToArray(request.param("index")));
        updateSettingsRequest.timeout(request.paramAsTime("timeout", updateSettingsRequest.timeout()));
        updateSettingsRequest.setPreserveExisting(request.paramAsBoolean("preserve_existing", updateSettingsRequest.isPreserveExisting()));
        updateSettingsRequest.masterNodeTimeout(request.paramAsTime("master_timeout", updateSettingsRequest.masterNodeTimeout()));
        updateSettingsRequest.indicesOptions(IndicesOptions.fromRequest(request, updateSettingsRequest.indicesOptions()));
        updateSettingsRequest.fromXContent(request.contentParser());
        return channel -> client.admin().indices().updateSettings(updateSettingsRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }
}

