/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.script;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.index.fielddata.ScriptDocValues;
import conductor.org.elasticsearch.script.ParameterMap;
import conductor.org.elasticsearch.script.ScriptContext;
import conductor.org.elasticsearch.search.lookup.LeafSearchLookup;
import conductor.org.elasticsearch.search.lookup.SearchLookup;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScriptedMetricAggContexts {

    public static abstract class ReduceScript {
        private static final Map<String, String> DEPRECATIONS;
        private final Map<String, Object> params;
        private final List<Object> states;
        public static String[] PARAMETERS;
        public static ScriptContext<Factory> CONTEXT;

        public ReduceScript(Map<String, Object> params, List<Object> states) {
            this.params = new ParameterMap(params, DEPRECATIONS);
            this.states = states;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public List<Object> getStates() {
            return this.states;
        }

        public abstract Object execute();

        static {
            HashMap<String, String> deprecations = new HashMap<String, String>();
            deprecations.put("_aggs", "Accessing variable [_aggs] via [params._aggs] from within a scripted metric agg reduce script is deprecated in favor of using [state].");
            DEPRECATIONS = Collections.unmodifiableMap(deprecations);
            PARAMETERS = new String[0];
            CONTEXT = new ScriptContext<Factory>("aggs_reduce", Factory.class);
        }

        public static interface Factory {
            public ReduceScript newInstance(Map<String, Object> var1, List<Object> var2);
        }
    }

    public static abstract class CombineScript {
        private static final Map<String, String> DEPRECATIONS;
        private final Map<String, Object> params;
        private final Object state;
        public static String[] PARAMETERS;
        public static ScriptContext<Factory> CONTEXT;

        public CombineScript(Map<String, Object> params, Object state) {
            this.params = new ParameterMap(params, DEPRECATIONS);
            this.state = state;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public Object getState() {
            return this.state;
        }

        public abstract Object execute();

        static {
            HashMap<String, String> deprecations = new HashMap<String, String>();
            deprecations.put("_agg", "Accessing variable [_agg] via [params._agg] from within a scripted metric agg combine script is deprecated in favor of using [state].");
            DEPRECATIONS = Collections.unmodifiableMap(deprecations);
            PARAMETERS = new String[0];
            CONTEXT = new ScriptContext<Factory>("aggs_combine", Factory.class);
        }

        public static interface Factory {
            public CombineScript newInstance(Map<String, Object> var1, Object var2);
        }
    }

    public static abstract class MapScript {
        private static final Map<String, String> DEPRECATIONS;
        private final Map<String, Object> params;
        private final Object state;
        private final LeafSearchLookup leafLookup;
        private Scorer scorer;
        public static String[] PARAMETERS;
        public static ScriptContext<Factory> CONTEXT;

        public MapScript(Map<String, Object> params, Object state, SearchLookup lookup, LeafReaderContext leafContext) {
            this.state = state;
            LeafSearchLookup leafSearchLookup = this.leafLookup = leafContext == null ? null : lookup.getLeafSearchLookup(leafContext);
            if (this.leafLookup != null) {
                params = new HashMap<String, Object>(params);
                params.putAll(this.leafLookup.asMap());
                params = new ParameterMap(params, DEPRECATIONS);
            }
            this.params = params;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public Object getState() {
            return this.state;
        }

        public Map<String, ScriptDocValues<?>> getDoc() {
            return this.leafLookup == null ? null : this.leafLookup.doc();
        }

        public void setDocument(int docId) {
            if (this.leafLookup != null) {
                this.leafLookup.setDocument(docId);
            }
        }

        public void setScorer(Scorer scorer) {
            this.scorer = scorer;
        }

        public double get_score() {
            if (this.scorer == null) {
                return 0.0;
            }
            try {
                return this.scorer.score();
            }
            catch (IOException e) {
                throw new ElasticsearchException("Couldn't look up score", (Throwable)e, new Object[0]);
            }
        }

        public abstract void execute();

        static {
            HashMap<String, String> deprecations = new HashMap<String, String>();
            deprecations.put("doc", "Accessing variable [doc] via [params.doc] from within a scripted metric agg map script is deprecated in favor of directly accessing [doc].");
            deprecations.put("_doc", "Accessing variable [doc] via [params._doc] from within a scripted metric agg map script is deprecated in favor of directly accessing [doc].");
            deprecations.put("_agg", "Accessing variable [_agg] via [params._agg] from within a scripted metric agg map script is deprecated in favor of using [state].");
            DEPRECATIONS = Collections.unmodifiableMap(deprecations);
            PARAMETERS = new String[0];
            CONTEXT = new ScriptContext<Factory>("aggs_map", Factory.class);
        }

        public static interface Factory {
            public LeafFactory newFactory(Map<String, Object> var1, Object var2, SearchLookup var3);
        }

        public static interface LeafFactory {
            public MapScript newInstance(LeafReaderContext var1);
        }
    }

    public static abstract class InitScript {
        private static final Map<String, String> DEPRECATIONS;
        private final Map<String, Object> params;
        private final Object state;
        public static String[] PARAMETERS;
        public static ScriptContext<Factory> CONTEXT;

        public InitScript(Map<String, Object> params, Object state) {
            this.params = new ParameterMap(params, DEPRECATIONS);
            this.state = state;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public Object getState() {
            return this.state;
        }

        public abstract void execute();

        static {
            HashMap<String, String> deprecations = new HashMap<String, String>();
            deprecations.put("_agg", "Accessing variable [_agg] via [params._agg] from within a scripted metric agg init script is deprecated in favor of using [state].");
            DEPRECATIONS = Collections.unmodifiableMap(deprecations);
            PARAMETERS = new String[0];
            CONTEXT = new ScriptContext<Factory>("aggs_init", Factory.class);
        }

        public static interface Factory {
            public InitScript newInstance(Map<String, Object> var1, Object var2);
        }
    }
}

