/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.queries.function.valuesource;

import conductor.org.apache.lucene.queries.function.FunctionValues;
import conductor.org.apache.lucene.queries.function.ValueSource;
import conductor.org.apache.lucene.queries.function.valuesource.MultiFloatFunction;
import conductor.org.apache.lucene.queries.function.valuesource.MultiFunction;
import java.io.IOException;

public class MinFloatFunction
extends MultiFloatFunction {
    public MinFloatFunction(ValueSource[] sources) {
        super(sources);
    }

    @Override
    protected String name() {
        return "min";
    }

    @Override
    protected float func(int doc, FunctionValues[] valsArr) throws IOException {
        if (!this.exists(doc, valsArr)) {
            return 0.0f;
        }
        float val = Float.POSITIVE_INFINITY;
        for (FunctionValues vals : valsArr) {
            if (!vals.exists(doc)) continue;
            val = Math.min(vals.floatVal(doc), val);
        }
        return val;
    }

    @Override
    protected boolean exists(int doc, FunctionValues[] valsArr) throws IOException {
        return MultiFunction.anyExists(doc, valsArr);
    }
}

