/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search;

import conductor.org.apache.lucene.search.CollectionTerminatedException;
import conductor.org.apache.lucene.search.DocIdSetIterator;
import java.io.IOException;

public abstract class XFilteredDocIdSetIterator
extends DocIdSetIterator {
    protected DocIdSetIterator _innerIter;
    private int doc;

    public XFilteredDocIdSetIterator(DocIdSetIterator innerIter) {
        if (innerIter == null) {
            throw new IllegalArgumentException("null iterator");
        }
        this._innerIter = innerIter;
        this.doc = -1;
    }

    public DocIdSetIterator getDelegate() {
        return this._innerIter;
    }

    protected abstract boolean match(int var1);

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int nextDoc() throws IOException {
        try {
            while ((this.doc = this._innerIter.nextDoc()) != Integer.MAX_VALUE) {
                if (!this.match(this.doc)) continue;
                return this.doc;
            }
        }
        catch (CollectionTerminatedException e) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        return this.doc;
    }

    @Override
    public int advance(int target) throws IOException {
        this.doc = this._innerIter.advance(target);
        try {
            if (this.doc != Integer.MAX_VALUE) {
                if (this.match(this.doc)) {
                    return this.doc;
                }
                while ((this.doc = this._innerIter.nextDoc()) != Integer.MAX_VALUE) {
                    if (!this.match(this.doc)) continue;
                    return this.doc;
                }
                return this.doc;
            }
        }
        catch (CollectionTerminatedException e) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        return this.doc;
    }

    @Override
    public long cost() {
        return this._innerIter.cost();
    }
}

