/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.join;

import conductor.org.apache.lucene.index.BinaryDocValues;
import conductor.org.apache.lucene.index.DocValues;
import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.SortedSetDocValues;
import conductor.org.apache.lucene.search.SimpleCollector;
import java.io.IOException;

abstract class DocValuesTermsCollector<DV>
extends SimpleCollector {
    protected DV docValues;
    private final Function<DV> docValuesCall;

    public DocValuesTermsCollector(Function<DV> docValuesCall) {
        this.docValuesCall = docValuesCall;
    }

    @Override
    protected final void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = this.docValuesCall.apply(context.reader());
    }

    static Function<BinaryDocValues> binaryDocValues(String field) {
        return ctx -> DocValues.getBinary(ctx, field);
    }

    static Function<SortedSetDocValues> sortedSetDocValues(String field) {
        return ctx -> DocValues.getSortedSet(ctx, field);
    }

    @FunctionalInterface
    static interface Function<R> {
        public R apply(LeafReader var1) throws IOException;
    }
}

