/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.indices.shrink;

import conductor.org.elasticsearch.action.Action;
import conductor.org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import conductor.org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import conductor.org.elasticsearch.action.admin.indices.shrink.ResizeResponse;
import conductor.org.elasticsearch.action.admin.indices.shrink.ResizeType;
import conductor.org.elasticsearch.action.support.ActiveShardCount;
import conductor.org.elasticsearch.action.support.master.AcknowledgedRequestBuilder;
import conductor.org.elasticsearch.client.ElasticsearchClient;
import conductor.org.elasticsearch.common.settings.Settings;

public class ResizeRequestBuilder
extends AcknowledgedRequestBuilder<ResizeRequest, ResizeResponse, ResizeRequestBuilder> {
    public ResizeRequestBuilder(ElasticsearchClient client, Action<ResizeRequest, ResizeResponse, ResizeRequestBuilder> action) {
        super(client, action, new ResizeRequest());
    }

    public ResizeRequestBuilder setTargetIndex(CreateIndexRequest request) {
        ((ResizeRequest)this.request).setTargetIndex(request);
        return this;
    }

    public ResizeRequestBuilder setSourceIndex(String index) {
        ((ResizeRequest)this.request).setSourceIndex(index);
        return this;
    }

    public ResizeRequestBuilder setSettings(Settings settings) {
        ((ResizeRequest)this.request).getTargetIndexRequest().settings(settings);
        return this;
    }

    public ResizeRequestBuilder setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        ((ResizeRequest)this.request).setWaitForActiveShards(waitForActiveShards);
        return this;
    }

    public ResizeRequestBuilder setWaitForActiveShards(int waitForActiveShards) {
        return this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public ResizeRequestBuilder setResizeType(ResizeType type) {
        ((ResizeRequest)this.request).setResizeType(type);
        return this;
    }
}

