/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.inject;

import conductor.org.elasticsearch.common.inject.internal.Errors;
import conductor.org.elasticsearch.common.inject.spi.Message;
import conductor.org.elasticsearch.common.util.set.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;

public final class ConfigurationException
extends RuntimeException {
    private final Set<Message> messages;
    private Object partialValue = null;

    public ConfigurationException(Iterable<Message> messages) {
        this.messages = Collections.unmodifiableSet(Sets.newHashSet(messages));
        this.initCause(Errors.getOnlyCause(this.messages));
    }

    public ConfigurationException withPartialValue(Object partialValue) {
        if (this.partialValue != null) {
            String message = String.format(Locale.ROOT, "Can't clobber existing partial value %s with %s", this.partialValue, partialValue);
            throw new IllegalStateException(message);
        }
        ConfigurationException result = new ConfigurationException(this.messages);
        result.partialValue = partialValue;
        return result;
    }

    public Collection<Message> getErrorMessages() {
        return this.messages;
    }

    public <E> E getPartialValue() {
        return (E)this.partialValue;
    }

    @Override
    public String getMessage() {
        return Errors.format("Guice configuration errors", this.messages);
    }
}

