/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.mapper;

import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.search.BoostQuery;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.TermInSetQuery;
import conductor.org.apache.lucene.search.TermQuery;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.lucene.BytesRefs;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.mapper.SimpleMappedFieldType;
import conductor.org.elasticsearch.index.query.QueryShardContext;
import java.util.List;

abstract class TermBasedFieldType
extends SimpleMappedFieldType {
    TermBasedFieldType() {
    }

    protected TermBasedFieldType(MappedFieldType ref) {
        super(ref);
    }

    protected BytesRef indexedValueForSearch(Object value) {
        return BytesRefs.toBytesRef(value);
    }

    @Override
    public Query termQuery(Object value, QueryShardContext context) {
        this.failIfNotIndexed();
        TermQuery query = new TermQuery(new Term(this.name(), this.indexedValueForSearch(value)));
        if (this.boost() == 1.0f || context != null && context.indexVersionCreated().before(Version.V_5_0_0_alpha1)) {
            return query;
        }
        return new BoostQuery(query, this.boost());
    }

    @Override
    public Query termsQuery(List<?> values, QueryShardContext context) {
        this.failIfNotIndexed();
        BytesRef[] bytesRefs = new BytesRef[values.size()];
        for (int i = 0; i < bytesRefs.length; ++i) {
            bytesRefs[i] = this.indexedValueForSearch(values.get(i));
        }
        return new TermInSetQuery(this.name(), bytesRefs);
    }
}

