/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.indices.analysis;

import conductor.org.apache.lucene.analysis.Analyzer;
import conductor.org.apache.lucene.analysis.CharArraySet;
import conductor.org.apache.lucene.analysis.core.KeywordAnalyzer;
import conductor.org.apache.lucene.analysis.core.SimpleAnalyzer;
import conductor.org.apache.lucene.analysis.core.StopAnalyzer;
import conductor.org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import conductor.org.apache.lucene.analysis.standard.ClassicAnalyzer;
import conductor.org.apache.lucene.analysis.standard.StandardAnalyzer;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.indices.analysis.PreBuiltCacheFactory;
import java.util.Locale;

public enum PreBuiltAnalyzers {
    STANDARD(PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH){

        @Override
        protected Analyzer create(Version version) {
            StandardAnalyzer a = new StandardAnalyzer(CharArraySet.EMPTY_SET);
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    DEFAULT(PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH){

        @Override
        protected Analyzer create(Version version) {
            return STANDARD.getAnalyzer(version);
        }
    }
    ,
    KEYWORD(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Analyzer create(Version version) {
            return new KeywordAnalyzer();
        }
    }
    ,
    STOP{

        @Override
        protected Analyzer create(Version version) {
            StopAnalyzer a = new StopAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    WHITESPACE{

        @Override
        protected Analyzer create(Version version) {
            WhitespaceAnalyzer a = new WhitespaceAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    SIMPLE{

        @Override
        protected Analyzer create(Version version) {
            SimpleAnalyzer a = new SimpleAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    CLASSIC{

        @Override
        protected Analyzer create(Version version) {
            ClassicAnalyzer a = new ClassicAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    };

    protected final PreBuiltCacheFactory.PreBuiltCache<Analyzer> cache;

    protected abstract Analyzer create(Version var1);

    private PreBuiltAnalyzers() {
        this(PreBuiltCacheFactory.CachingStrategy.LUCENE);
    }

    private PreBuiltAnalyzers(PreBuiltCacheFactory.CachingStrategy cachingStrategy) {
        this.cache = PreBuiltCacheFactory.getCache(cachingStrategy);
    }

    public PreBuiltCacheFactory.PreBuiltCache<Analyzer> getCache() {
        return this.cache;
    }

    public synchronized Analyzer getAnalyzer(Version version) {
        Analyzer analyzer = this.cache.get(version);
        if (analyzer == null) {
            analyzer = this.create(version);
            this.cache.put(version, analyzer);
        }
        return analyzer;
    }

    public static PreBuiltAnalyzers getOrDefault(String name, PreBuiltAnalyzers defaultAnalyzer) {
        try {
            return PreBuiltAnalyzers.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return defaultAnalyzer;
        }
    }
}

