/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.persistent;

import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import conductor.org.elasticsearch.cluster.ClusterChangedEvent;
import conductor.org.elasticsearch.cluster.ClusterStateListener;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.component.AbstractComponent;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.gateway.GatewayService;
import conductor.org.elasticsearch.persistent.AllocatedPersistentTask;
import conductor.org.elasticsearch.persistent.NodePersistentTasksExecutor;
import conductor.org.elasticsearch.persistent.PersistentTaskParams;
import conductor.org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import conductor.org.elasticsearch.persistent.PersistentTasksExecutor;
import conductor.org.elasticsearch.persistent.PersistentTasksExecutorRegistry;
import conductor.org.elasticsearch.persistent.PersistentTasksService;
import conductor.org.elasticsearch.tasks.Task;
import conductor.org.elasticsearch.tasks.TaskAwareRequest;
import conductor.org.elasticsearch.tasks.TaskId;
import conductor.org.elasticsearch.tasks.TaskManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

public class PersistentTasksNodeService
extends AbstractComponent
implements ClusterStateListener {
    private final Map<Long, AllocatedPersistentTask> runningTasks = new HashMap<Long, AllocatedPersistentTask>();
    private final PersistentTasksService persistentTasksService;
    private final PersistentTasksExecutorRegistry persistentTasksExecutorRegistry;
    private final TaskManager taskManager;
    private final NodePersistentTasksExecutor nodePersistentTasksExecutor;

    public PersistentTasksNodeService(Settings settings, PersistentTasksService persistentTasksService, PersistentTasksExecutorRegistry persistentTasksExecutorRegistry, TaskManager taskManager, NodePersistentTasksExecutor nodePersistentTasksExecutor) {
        super(settings);
        this.persistentTasksService = persistentTasksService;
        this.persistentTasksExecutorRegistry = persistentTasksExecutorRegistry;
        this.taskManager = taskManager;
        this.nodePersistentTasksExecutor = nodePersistentTasksExecutor;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        PersistentTasksCustomMetaData previousTasks;
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)event.state().getMetaData().custom("persistent_tasks");
        if (!Objects.equals(tasks, previousTasks = (PersistentTasksCustomMetaData)event.previousState().getMetaData().custom("persistent_tasks")) || event.nodesChanged()) {
            String localNodeId = event.state().getNodes().getLocalNodeId();
            HashSet<Long> notVisitedTasks = new HashSet<Long>(this.runningTasks.keySet());
            if (tasks != null) {
                for (PersistentTasksCustomMetaData.PersistentTask persistentTask : tasks.tasks()) {
                    if (!localNodeId.equals(persistentTask.getExecutorNode())) continue;
                    Long allocationId = persistentTask.getAllocationId();
                    AllocatedPersistentTask persistentTask2 = this.runningTasks.get(allocationId);
                    if (persistentTask2 == null) {
                        this.startTask(persistentTask);
                        continue;
                    }
                    notVisitedTasks.remove(allocationId);
                }
            }
            for (Long l : notVisitedTasks) {
                AllocatedPersistentTask task = this.runningTasks.get(l);
                if (task.isCompleted()) {
                    this.logger.trace("Found completed persistent task [{}] with id [{}] and allocation id [{}] - removing", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
                    this.runningTasks.remove(l);
                    continue;
                }
                this.logger.trace("Found unregistered persistent task [{}] with id [{}] and allocation id [{}] - cancelling", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
                this.cancelTask(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Params extends PersistentTaskParams> void startTask(final PersistentTasksCustomMetaData.PersistentTask<Params> taskInProgress) {
        final PersistentTasksExecutor executor = this.persistentTasksExecutorRegistry.getPersistentTaskExecutorSafe(taskInProgress.getTaskName());
        TaskAwareRequest request = new TaskAwareRequest(){
            TaskId parentTaskId;
            {
                this.parentTaskId = new TaskId("cluster", taskInProgress.getAllocationId());
            }

            @Override
            public void setParentTask(TaskId taskId) {
                throw new UnsupportedOperationException("parent task if for persistent tasks shouldn't change");
            }

            @Override
            public TaskId getParentTask() {
                return this.parentTaskId;
            }

            @Override
            public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
                return executor.createTask(id, type, action, parentTaskId, taskInProgress, headers);
            }
        };
        AllocatedPersistentTask task = (AllocatedPersistentTask)this.taskManager.register("persistent", taskInProgress.getTaskName() + "[c]", request);
        boolean processed = false;
        try {
            task.init(this.persistentTasksService, this.taskManager, this.logger, taskInProgress.getId(), taskInProgress.getAllocationId());
            this.logger.trace("Persistent task [{}] with id [{}] and allocation id [{}] was created", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
            try {
                this.runningTasks.put(taskInProgress.getAllocationId(), task);
                this.nodePersistentTasksExecutor.executeTask(taskInProgress.getParams(), taskInProgress.getState(), task, executor);
            }
            catch (Exception e) {
                task.markAsFailed(e);
            }
            processed = true;
        }
        finally {
            if (!processed) {
                this.logger.warn("Persistent task [{}] with id [{}] and allocation id [{}] failed to create", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
                this.taskManager.unregister(task);
            }
        }
    }

    private void cancelTask(Long allocationId) {
        final AllocatedPersistentTask task = this.runningTasks.remove(allocationId);
        if (task.markAsCancelled()) {
            String reason = "task has been removed, cancelling locally";
            this.persistentTasksService.sendCancelRequest(task.getId(), reason, new ActionListener<CancelTasksResponse>(){

                @Override
                public void onResponse(CancelTasksResponse cancelTasksResponse) {
                    PersistentTasksNodeService.this.logger.trace("Persistent task [{}] with id [{}] and allocation id [{}] was cancelled", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
                }

                @Override
                public void onFailure(Exception e) {
                    PersistentTasksNodeService.this.logger.warn(() -> new ParameterizedMessage("failed to cancel task [{}] with id [{}] and allocation id [{}]", task.getAction(), task.getPersistentTaskId(), task.getAllocationId()), (Throwable)e);
                }
            });
        }
    }

    public static class Status
    implements Task.Status {
        public static final String NAME = "persistent_executor";
        private final AllocatedPersistentTask.State state;

        public Status(AllocatedPersistentTask.State state) {
            this.state = Objects.requireNonNull(state, "State cannot be null");
        }

        public Status(StreamInput in) throws IOException {
            this.state = AllocatedPersistentTask.State.valueOf(in.readString());
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("state", this.state.toString());
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.state.toString());
        }

        public String toString() {
            return Strings.toString(this);
        }

        @Override
        public boolean isFragment() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.state == status.state;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.state});
        }
    }
}

