/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.repositories.blobstore;

import conductor.org.apache.lucene.codecs.CodecUtil;
import conductor.org.apache.lucene.index.CorruptIndexException;
import conductor.org.apache.lucene.index.IndexFormatTooNewException;
import conductor.org.apache.lucene.index.IndexFormatTooOldException;
import conductor.org.apache.lucene.store.OutputStreamIndexOutput;
import conductor.org.elasticsearch.common.CheckedConsumer;
import conductor.org.elasticsearch.common.CheckedFunction;
import conductor.org.elasticsearch.common.blobstore.BlobContainer;
import conductor.org.elasticsearch.common.bytes.BytesArray;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.compress.CompressorFactory;
import conductor.org.elasticsearch.common.io.stream.BytesStreamOutput;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.lucene.store.ByteArrayIndexInput;
import conductor.org.elasticsearch.common.lucene.store.IndexOutputOutputStream;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentFactory;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import conductor.org.elasticsearch.core.internal.io.Streams;
import conductor.org.elasticsearch.gateway.CorruptStateException;
import conductor.org.elasticsearch.repositories.blobstore.BlobStoreFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ChecksumBlobStoreFormat<T extends ToXContent>
extends BlobStoreFormat<T> {
    private static final XContentType DEFAULT_X_CONTENT_TYPE = XContentType.SMILE;
    public static final int VERSION = 1;
    private static final int BUFFER_SIZE = 4096;
    protected final XContentType xContentType;
    protected final boolean compress;
    private final String codec;

    public ChecksumBlobStoreFormat(String codec, String blobNameFormat, CheckedFunction<XContentParser, T, IOException> reader, NamedXContentRegistry namedXContentRegistry, boolean compress, XContentType xContentType) {
        super(blobNameFormat, reader, namedXContentRegistry);
        this.xContentType = xContentType;
        this.compress = compress;
        this.codec = codec;
    }

    public ChecksumBlobStoreFormat(String codec, String blobNameFormat, CheckedFunction<XContentParser, T, IOException> reader, NamedXContentRegistry namedXContentRegistry, boolean compress) {
        this(codec, blobNameFormat, reader, namedXContentRegistry, compress, DEFAULT_X_CONTENT_TYPE);
    }

    /*
     * Loose catch block
     */
    @Override
    public T readBlob(BlobContainer blobContainer, String blobName) throws IOException {
        try (InputStream inputStream = blobContainer.readBlob(blobName);){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Streams.copy(inputStream, out);
            byte[] bytes = out.toByteArray();
            String resourceDesc = "ChecksumBlobStoreFormat.readBlob(blob=\"" + blobName + "\")";
            ByteArrayIndexInput indexInput = new ByteArrayIndexInput(resourceDesc, bytes);
            CodecUtil.checksumEntireFile(indexInput);
            CodecUtil.checkHeader(indexInput, this.codec, 1, 1);
            long filePointer = indexInput.getFilePointer();
            long contentSize = indexInput.length() - (long)CodecUtil.footerLength() - filePointer;
            BytesArray bytesReference = new BytesArray(bytes, (int)filePointer, (int)contentSize);
            Object t = this.read(bytesReference);
            indexInput.close();
            return t;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            indexInput.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                        throw new CorruptStateException(ex);
                    }
                }
            }
        }
    }

    public void writeAtomic(T obj, BlobContainer blobContainer, String name) throws IOException {
        String blobName = this.blobName(name);
        this.writeTo(obj, blobName, bytesArray -> {
            try (StreamInput stream = bytesArray.streamInput();){
                blobContainer.writeBlobAtomic(blobName, stream, bytesArray.length(), true);
            }
        });
    }

    public void write(T obj, BlobContainer blobContainer, String name) throws IOException {
        String blobName = this.blobName(name);
        this.writeTo(obj, blobName, bytesArray -> {
            try (StreamInput stream = bytesArray.streamInput();){
                blobContainer.writeBlob(blobName, stream, bytesArray.length(), true);
            }
        });
    }

    private void writeTo(T obj, String blobName, CheckedConsumer<BytesArray, IOException> consumer) throws IOException {
        BytesReference bytes = this.write(obj);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String resourceDesc = "ChecksumBlobStoreFormat.writeBlob(blob=\"" + blobName + "\")";
            try (OutputStreamIndexOutput indexOutput = new OutputStreamIndexOutput(resourceDesc, blobName, outputStream, 4096);){
                CodecUtil.writeHeader(indexOutput, this.codec, 1);
                try (IndexOutputOutputStream indexOutputOutputStream = new IndexOutputOutputStream(indexOutput){

                    @Override
                    public void close() throws IOException {
                    }
                };){
                    bytes.writeTo(indexOutputOutputStream);
                }
                CodecUtil.writeFooter(indexOutput);
            }
            consumer.accept(new BytesArray(outputStream.toByteArray()));
        }
    }

    protected BytesReference write(T obj) throws IOException {
        try (BytesStreamOutput bytesStreamOutput = new BytesStreamOutput();){
            if (this.compress) {
                try (StreamOutput compressedStreamOutput = CompressorFactory.COMPRESSOR.streamOutput(bytesStreamOutput);){
                    this.write(obj, compressedStreamOutput);
                }
            } else {
                this.write(obj, bytesStreamOutput);
            }
            BytesReference bytesReference = bytesStreamOutput.bytes();
            return bytesReference;
        }
    }

    protected void write(T obj, StreamOutput streamOutput) throws IOException {
        try (XContentBuilder builder = XContentFactory.contentBuilder(this.xContentType, streamOutput);){
            builder.startObject();
            obj.toXContent(builder, SNAPSHOT_ONLY_FORMAT_PARAMS);
            builder.endObject();
        }
    }
}

