/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.transport;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.transport.TransportRequest;
import java.io.IOException;

public class BytesTransportRequest
extends TransportRequest {
    BytesReference bytes;
    Version version;

    public BytesTransportRequest() {
    }

    public BytesTransportRequest(BytesReference bytes, Version version) {
        this.bytes = bytes;
        this.version = version;
    }

    public Version version() {
        return this.version;
    }

    public BytesReference bytes() {
        return this.bytes;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.bytes = in.readBytesReference();
        this.version = in.getVersion();
    }

    public void writeThin(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.bytes.length());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesReference(this.bytes);
    }
}

