/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.elasticsearch.query.parser;

import com.netflix.conductor.elasticsearch.query.parser.AbstractNode;
import com.netflix.conductor.elasticsearch.query.parser.ParserException;
import java.io.InputStream;

public class ComparisonOp
extends AbstractNode {
    private static final int maxOperatorLength;
    private static final int betweenLen;
    private static final int startsWithLen;
    private String value;

    public ComparisonOp(InputStream is) throws ParserException {
        super(is);
    }

    @Override
    protected void _parse() throws Exception {
        byte[] peeked = this.peek(maxOperatorLength);
        if (peeked[0] == 61 || peeked[0] == 62 || peeked[0] == 60) {
            this.value = new String(peeked, 0, 1);
        } else if (peeked[0] == 73 && peeked[1] == 78) {
            this.value = "IN";
        } else if (peeked[0] == 73 && peeked[1] == 83) {
            this.value = "IS";
        } else if (peeked[0] == 33 && peeked[1] == 61) {
            this.value = "!=";
        } else if (peeked.length >= betweenLen && peeked[0] == 66 && peeked[1] == 69 && peeked[2] == 84 && peeked[3] == 87 && peeked[4] == 69 && peeked[5] == 69 && peeked[6] == 78) {
            this.value = Operators.BETWEEN.value();
        } else if (peeked.length == startsWithLen && new String(peeked).equals(Operators.STARTS_WITH.value())) {
            this.value = Operators.STARTS_WITH.value();
        } else {
            throw new ParserException("Expecting an operator (=, >, <, !=, BETWEEN, IN, STARTS_WITH), but found none.  Peeked=>" + new String(peeked));
        }
        this.read(this.value.length());
    }

    public String toString() {
        return " " + this.value + " ";
    }

    public String getOperator() {
        return this.value;
    }

    static {
        int max = 0;
        for (Operators op : Operators.values()) {
            max = Math.max(max, op.value().length());
        }
        maxOperatorLength = max;
        betweenLen = Operators.BETWEEN.value().length();
        startsWithLen = Operators.STARTS_WITH.value().length();
    }

    public static enum Operators {
        BETWEEN("BETWEEN"),
        EQUALS("="),
        LESS_THAN("<"),
        GREATER_THAN(">"),
        IN("IN"),
        NOT_EQUALS("!="),
        IS("IS"),
        STARTS_WITH("STARTS_WITH");

        private final String value;

        private Operators(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

