/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.geo;

import conductor.org.apache.lucene.geo.EdgeTree;
import conductor.org.apache.lucene.geo.Polygon;
import conductor.org.apache.lucene.index.PointValues;

public final class Polygon2D
extends EdgeTree {
    private final Polygon2D holes;

    private Polygon2D(Polygon polygon, Polygon2D holes) {
        super(polygon.minLat, polygon.maxLat, polygon.minLon, polygon.maxLon, polygon.getPolyLats(), polygon.getPolyLons());
        this.holes = holes;
    }

    public boolean contains(double latitude, double longitude) {
        if (latitude <= this.maxY && longitude <= this.maxX) {
            if (this.componentContains(latitude, longitude)) {
                return true;
            }
            if (this.left != null && ((Polygon2D)this.left).contains(latitude, longitude)) {
                return true;
            }
            if (this.right != null && (!this.splitX && latitude >= this.minLat || this.splitX && longitude >= this.minLon) && ((Polygon2D)this.right).contains(latitude, longitude)) {
                return true;
            }
        }
        return false;
    }

    private boolean componentContains(double latitude, double longitude) {
        if (latitude < this.minLat || latitude > this.maxLat || longitude < this.minLon || longitude > this.maxLon) {
            return false;
        }
        if (Polygon2D.contains(this.tree, latitude, longitude)) {
            return this.holes == null || !this.holes.contains(latitude, longitude);
        }
        return false;
    }

    @Override
    protected PointValues.Relation componentRelateTriangle(double ax, double ay, double bx, double by, double cx, double cy) {
        int numCorners;
        if (this.holes != null) {
            PointValues.Relation holeRelation = this.holes.relateTriangle(ax, ay, bx, by, cx, cy);
            if (holeRelation == PointValues.Relation.CELL_CROSSES_QUERY) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            if (holeRelation == PointValues.Relation.CELL_INSIDE_QUERY) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        }
        if ((numCorners = this.numberOfTriangleCorners(ax, ay, bx, by, cx, cy)) == 3) {
            if (this.tree.relateTriangle(ax, ay, bx, by, cx, cy) == PointValues.Relation.CELL_CROSSES_QUERY) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        if (numCorners > 0) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return null;
    }

    @Override
    protected PointValues.Relation componentRelate(double minLat, double maxLat, double minLon, double maxLon) {
        int numCorners;
        if (this.holes != null) {
            PointValues.Relation holeRelation = this.holes.relate(minLat, maxLat, minLon, maxLon);
            if (holeRelation == PointValues.Relation.CELL_CROSSES_QUERY) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            if (holeRelation == PointValues.Relation.CELL_INSIDE_QUERY) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        }
        if ((numCorners = this.numberOfCorners(minLat, maxLat, minLon, maxLon)) == 4) {
            if (this.tree.crosses(minLat, maxLat, minLon, maxLon)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        if (numCorners > 0) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return null;
    }

    private int numberOfTriangleCorners(double ax, double ay, double bx, double by, double cx, double cy) {
        int containsCount = 0;
        if (this.componentContains(ay, ax)) {
            ++containsCount;
        }
        if (this.componentContains(by, bx)) {
            ++containsCount;
        }
        if (containsCount == 1) {
            return containsCount;
        }
        if (this.componentContains(cy, cx)) {
            ++containsCount;
        }
        return containsCount;
    }

    private int numberOfCorners(double minLat, double maxLat, double minLon, double maxLon) {
        int containsCount = 0;
        if (this.componentContains(minLat, minLon)) {
            ++containsCount;
        }
        if (this.componentContains(minLat, maxLon)) {
            ++containsCount;
        }
        if (containsCount == 1) {
            return containsCount;
        }
        if (this.componentContains(maxLat, maxLon)) {
            ++containsCount;
        }
        if (containsCount == 2) {
            return containsCount;
        }
        if (this.componentContains(maxLat, minLon)) {
            ++containsCount;
        }
        return containsCount;
    }

    public static Polygon2D create(Polygon ... polygons) {
        EdgeTree[] components = new Polygon2D[polygons.length];
        for (int i = 0; i < components.length; ++i) {
            Polygon gon = polygons[i];
            Polygon[] gonHoles = gon.getHoles();
            Polygon2D holes = null;
            if (gonHoles.length > 0) {
                holes = Polygon2D.create(gonHoles);
            }
            components[i] = new Polygon2D(gon, holes);
        }
        return (Polygon2D)Polygon2D.createTree(components, 0, components.length - 1, false);
    }

    private static boolean contains(EdgeTree.Edge tree, double latitude, double longitude) {
        boolean res = false;
        if (latitude <= tree.max) {
            if (tree.lat1 > latitude != tree.lat2 > latitude && longitude < (tree.lon1 - tree.lon2) * (latitude - tree.lat2) / (tree.lat1 - tree.lat2) + tree.lon2) {
                res = true;
            }
            if (tree.left != null) {
                res ^= Polygon2D.contains(tree.left, latitude, longitude);
            }
            if (tree.right != null && latitude >= tree.low) {
                res ^= Polygon2D.contains(tree.right, latitude, longitude);
            }
        }
        return res;
    }
}

