/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.node.usage;

import conductor.org.elasticsearch.action.FailedNodeException;
import conductor.org.elasticsearch.action.admin.cluster.node.usage.NodeUsage;
import conductor.org.elasticsearch.action.admin.cluster.node.usage.NodesUsageRequest;
import conductor.org.elasticsearch.action.admin.cluster.node.usage.NodesUsageResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.nodes.BaseNodeRequest;
import conductor.org.elasticsearch.action.support.nodes.TransportNodesAction;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import conductor.org.elasticsearch.usage.UsageService;
import java.io.IOException;
import java.util.List;

public class TransportNodesUsageAction
extends TransportNodesAction<NodesUsageRequest, NodesUsageResponse, NodeUsageRequest, NodeUsage> {
    private UsageService usageService;

    @Inject
    public TransportNodesUsageAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, UsageService usageService) {
        super(settings, "cluster:monitor/nodes/usage", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, NodesUsageRequest::new, NodeUsageRequest::new, "management", NodeUsage.class);
        this.usageService = usageService;
    }

    @Override
    protected NodesUsageResponse newResponse(NodesUsageRequest request, List<NodeUsage> responses, List<FailedNodeException> failures) {
        return new NodesUsageResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeUsageRequest newNodeRequest(String nodeId, NodesUsageRequest request) {
        return new NodeUsageRequest(nodeId, request);
    }

    @Override
    protected NodeUsage newNodeResponse() {
        return new NodeUsage();
    }

    @Override
    protected NodeUsage nodeOperation(NodeUsageRequest nodeUsageRequest) {
        NodesUsageRequest request = nodeUsageRequest.request;
        return this.usageService.getUsageStats(this.clusterService.localNode(), request.restActions());
    }

    public static class NodeUsageRequest
    extends BaseNodeRequest {
        NodesUsageRequest request;

        public NodeUsageRequest() {
        }

        NodeUsageRequest(String nodeId, NodesUsageRequest request) {
            super(nodeId);
            this.request = request;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.request = new NodesUsageRequest();
            this.request.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

