/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.state;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.cluster.ClusterModule;
import conductor.org.elasticsearch.cluster.ClusterName;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.node.DiscoveryNodes;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.unit.ByteSizeValue;
import java.io.IOException;
import java.util.Objects;

public class ClusterStateResponse
extends ActionResponse {
    private ClusterName clusterName;
    private ClusterState clusterState;
    private ByteSizeValue totalCompressedSize;
    private boolean waitForTimedOut = false;

    public ClusterStateResponse() {
    }

    public ClusterStateResponse(ClusterName clusterName, ClusterState clusterState, long sizeInBytes, boolean waitForTimedOut) {
        this.clusterName = clusterName;
        this.clusterState = clusterState;
        this.totalCompressedSize = new ByteSizeValue(sizeInBytes);
        this.waitForTimedOut = waitForTimedOut;
    }

    public ClusterState getState() {
        return this.clusterState;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    @Deprecated
    public ByteSizeValue getTotalCompressedSize() {
        return this.totalCompressedSize;
    }

    public boolean isWaitForTimedOut() {
        return this.waitForTimedOut;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.clusterName = new ClusterName(in);
        this.clusterState = in.getVersion().onOrAfter(Version.V_6_6_0) ? in.readOptionalWriteable(innerIn -> ClusterState.readFrom(innerIn, null)) : ClusterState.readFrom(in, null);
        this.totalCompressedSize = in.getVersion().onOrAfter(Version.V_6_0_0_alpha1) ? new ByteSizeValue(in) : new ByteSizeValue(0L);
        if (in.getVersion().onOrAfter(Version.V_6_6_0)) {
            this.waitForTimedOut = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.clusterName.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
            out.writeOptionalWriteable(this.clusterState);
        } else if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            this.clusterState.writeTo(out);
        } else {
            ClusterModule.filterCustomsForPre63Clients(this.clusterState).writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
            this.totalCompressedSize.writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
            out.writeBoolean(this.waitForTimedOut);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStateResponse response = (ClusterStateResponse)o;
        return this.waitForTimedOut == response.waitForTimedOut && Objects.equals(this.clusterName, response.clusterName) && Objects.equals(ClusterStateResponse.getVersion(this.clusterState), ClusterStateResponse.getVersion(response.clusterState)) && Objects.equals(ClusterStateResponse.getMasterNodeId(this.clusterState), ClusterStateResponse.getMasterNodeId(response.clusterState)) && Objects.equals(this.totalCompressedSize, response.totalCompressedSize);
    }

    public int hashCode() {
        return Objects.hash(this.clusterName, ClusterStateResponse.getVersion(this.clusterState), ClusterStateResponse.getMasterNodeId(this.clusterState), this.totalCompressedSize, this.waitForTimedOut);
    }

    private static String getMasterNodeId(ClusterState clusterState) {
        if (clusterState == null) {
            return null;
        }
        DiscoveryNodes nodes = clusterState.getNodes();
        if (nodes != null) {
            return nodes.getMasterNodeId();
        }
        return null;
    }

    private static Long getVersion(ClusterState clusterState) {
        if (clusterState != null) {
            return clusterState.getVersion();
        }
        return null;
    }
}

