/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.search;

import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.action.search.CountedCollector;
import conductor.org.elasticsearch.action.search.InitialSearchPhase;
import conductor.org.elasticsearch.action.search.SearchActionListener;
import conductor.org.elasticsearch.action.search.SearchPhase;
import conductor.org.elasticsearch.action.search.SearchPhaseContext;
import conductor.org.elasticsearch.action.search.SearchPhaseController;
import conductor.org.elasticsearch.action.search.SearchTransportService;
import conductor.org.elasticsearch.common.util.concurrent.AtomicArray;
import conductor.org.elasticsearch.search.SearchPhaseResult;
import conductor.org.elasticsearch.search.SearchShardTarget;
import conductor.org.elasticsearch.search.dfs.AggregatedDfs;
import conductor.org.elasticsearch.search.dfs.DfsSearchResult;
import conductor.org.elasticsearch.search.query.QuerySearchRequest;
import conductor.org.elasticsearch.search.query.QuerySearchResult;
import conductor.org.elasticsearch.transport.Transport;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;

final class DfsQueryPhase
extends SearchPhase {
    private final InitialSearchPhase.ArraySearchPhaseResults<SearchPhaseResult> queryResult;
    private final SearchPhaseController searchPhaseController;
    private final AtomicArray<DfsSearchResult> dfsSearchResults;
    private final Function<InitialSearchPhase.ArraySearchPhaseResults<SearchPhaseResult>, SearchPhase> nextPhaseFactory;
    private final SearchPhaseContext context;
    private final SearchTransportService searchTransportService;

    DfsQueryPhase(AtomicArray<DfsSearchResult> dfsSearchResults, SearchPhaseController searchPhaseController, Function<InitialSearchPhase.ArraySearchPhaseResults<SearchPhaseResult>, SearchPhase> nextPhaseFactory, SearchPhaseContext context) {
        super("dfs_query");
        this.queryResult = searchPhaseController.newSearchPhaseResults(context.getRequest(), context.getNumShards());
        this.searchPhaseController = searchPhaseController;
        this.dfsSearchResults = dfsSearchResults;
        this.nextPhaseFactory = nextPhaseFactory;
        this.context = context;
        this.searchTransportService = context.getSearchTransport();
    }

    @Override
    public void run() throws IOException {
        List<DfsSearchResult> resultList = this.dfsSearchResults.asList();
        AggregatedDfs dfs = this.searchPhaseController.aggregateDfs(resultList);
        final CountedCollector<SearchPhaseResult> counter = new CountedCollector<SearchPhaseResult>(this.queryResult::consumeResult, resultList.size(), () -> this.context.executeNextPhase(this, this.nextPhaseFactory.apply(this.queryResult)), this.context);
        for (DfsSearchResult dfsResult : resultList) {
            final SearchShardTarget searchShardTarget = dfsResult.getSearchShardTarget();
            final Transport.Connection connection = this.context.getConnection(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId());
            final QuerySearchRequest querySearchRequest = new QuerySearchRequest(searchShardTarget.getOriginalIndices(), dfsResult.getRequestId(), dfs);
            final int shardIndex = dfsResult.getShardIndex();
            this.searchTransportService.sendExecuteQuery(connection, querySearchRequest, this.context.getTask(), new SearchActionListener<QuerySearchResult>(searchShardTarget, shardIndex){

                @Override
                protected void innerOnResponse(QuerySearchResult response) {
                    try {
                        counter.onResult(response);
                    }
                    catch (Exception e) {
                        DfsQueryPhase.this.context.onPhaseFailure(DfsQueryPhase.this, "", e);
                    }
                }

                @Override
                public void onFailure(Exception exception) {
                    try {
                        DfsQueryPhase.this.context.getLogger().debug(() -> new ParameterizedMessage("[{}] Failed to execute query phase", (Object)querySearchRequest.id()), (Throwable)exception);
                        counter.onFailure(shardIndex, searchShardTarget, exception);
                    }
                    finally {
                        DfsQueryPhase.this.context.sendReleaseSearchContext(querySearchRequest.id(), connection, searchShardTarget.getOriginalIndices());
                    }
                }
            });
        }
    }
}

