/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.support.master.info;

import conductor.org.elasticsearch.action.IndicesRequest;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.action.support.master.MasterNodeReadRequest;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import java.io.IOException;

public abstract class ClusterInfoRequest<Request extends ClusterInfoRequest<Request>>
extends MasterNodeReadRequest<Request>
implements IndicesRequest.Replaceable {
    private String[] indices = Strings.EMPTY_ARRAY;
    private String[] types = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

    public ClusterInfoRequest() {
    }

    public ClusterInfoRequest(StreamInput in) throws IOException {
        this.readFrom(in);
    }

    public Request indices(String ... indices) {
        this.indices = indices;
        return (Request)this;
    }

    public Request types(String ... types) {
        this.types = types;
        return (Request)this;
    }

    public Request indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return (Request)this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    public String[] types() {
        return this.types;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        this.types = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        out.writeStringArray(this.types);
        this.indicesOptions.writeIndicesOptions(out);
    }
}

