/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.ml;

import conductor.org.elasticsearch.client.Validatable;
import conductor.org.elasticsearch.client.ml.job.config.Job;
import conductor.org.elasticsearch.client.ml.job.util.PageParams;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Objects;

public class GetRecordsRequest
implements ToXContentObject,
Validatable {
    public static final ParseField EXCLUDE_INTERIM = new ParseField("exclude_interim", new String[0]);
    public static final ParseField START = new ParseField("start", new String[0]);
    public static final ParseField END = new ParseField("end", new String[0]);
    public static final ParseField RECORD_SCORE = new ParseField("record_score", new String[0]);
    public static final ParseField SORT = new ParseField("sort", new String[0]);
    public static final ParseField DESCENDING = new ParseField("desc", new String[0]);
    public static final ObjectParser<GetRecordsRequest, Void> PARSER = new ObjectParser("get_records_request", GetRecordsRequest::new);
    private String jobId;
    private Boolean excludeInterim;
    private String start;
    private String end;
    private PageParams pageParams;
    private Double recordScore;
    private String sort;
    private Boolean descending;

    private GetRecordsRequest() {
    }

    public GetRecordsRequest(String jobId) {
        this.jobId = Objects.requireNonNull(jobId);
    }

    public String getJobId() {
        return this.jobId;
    }

    public Boolean getExcludeInterim() {
        return this.excludeInterim;
    }

    public void setExcludeInterim(Boolean excludeInterim) {
        this.excludeInterim = excludeInterim;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public PageParams getPageParams() {
        return this.pageParams;
    }

    public void setPageParams(PageParams pageParams) {
        this.pageParams = pageParams;
    }

    public Double getRecordScore() {
        return this.recordScore;
    }

    public void setRecordScore(Double recordScore) {
        this.recordScore = recordScore;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public Boolean getDescending() {
        return this.descending;
    }

    public void setDescending(Boolean descending) {
        this.descending = descending;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        if (this.excludeInterim != null) {
            builder.field(EXCLUDE_INTERIM.getPreferredName(), this.excludeInterim);
        }
        if (this.start != null) {
            builder.field(START.getPreferredName(), this.start);
        }
        if (this.end != null) {
            builder.field(END.getPreferredName(), this.end);
        }
        if (this.pageParams != null) {
            builder.field(PageParams.PAGE.getPreferredName(), this.pageParams);
        }
        if (this.recordScore != null) {
            builder.field(RECORD_SCORE.getPreferredName(), this.recordScore);
        }
        if (this.sort != null) {
            builder.field(SORT.getPreferredName(), this.sort);
        }
        if (this.descending != null) {
            builder.field(DESCENDING.getPreferredName(), this.descending);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.excludeInterim, this.recordScore, this.pageParams, this.start, this.end, this.sort, this.descending);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetRecordsRequest other = (GetRecordsRequest)obj;
        return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.excludeInterim, other.excludeInterim) && Objects.equals(this.recordScore, other.recordScore) && Objects.equals(this.pageParams, other.pageParams) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.sort, other.sort) && Objects.equals(this.descending, other.descending);
    }

    static {
        PARSER.declareString((request, jobId) -> {
            request.jobId = jobId;
        }, Job.ID);
        PARSER.declareBoolean(GetRecordsRequest::setExcludeInterim, EXCLUDE_INTERIM);
        PARSER.declareStringOrNull(GetRecordsRequest::setStart, START);
        PARSER.declareStringOrNull(GetRecordsRequest::setEnd, END);
        PARSER.declareObject(GetRecordsRequest::setPageParams, PageParams.PARSER, PageParams.PAGE);
        PARSER.declareDouble(GetRecordsRequest::setRecordScore, RECORD_SCORE);
        PARSER.declareString(GetRecordsRequest::setSort, SORT);
        PARSER.declareBoolean(GetRecordsRequest::setDescending, DESCENDING);
    }
}

