/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.ml.job.stats;

import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Objects;

public class SimpleStats
implements ToXContentObject {
    public static final ParseField MIN = new ParseField("min", new String[0]);
    public static final ParseField MAX = new ParseField("max", new String[0]);
    public static final ParseField AVG = new ParseField("avg", new String[0]);
    public static final ParseField TOTAL = new ParseField("total", new String[0]);
    public static final ConstructingObjectParser<SimpleStats, Void> PARSER = new ConstructingObjectParser("simple_stats", true, a -> {
        int i = 0;
        double total = (Double)a[i++];
        double min = (Double)a[i++];
        double max = (Double)a[i++];
        double avg = (Double)a[i++];
        return new SimpleStats(total, min, max, avg);
    });
    private final double total;
    private final double min;
    private final double max;
    private final double avg;

    SimpleStats(double total, double min, double max, double avg) {
        this.total = total;
        this.min = min;
        this.max = max;
        this.avg = avg;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getAvg() {
        return this.avg;
    }

    public double getTotal() {
        return this.total;
    }

    public int hashCode() {
        return Objects.hash(this.total, this.min, this.max, this.avg);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleStats other = (SimpleStats)obj;
        return Objects.equals(this.total, other.total) && Objects.equals(this.min, other.min) && Objects.equals(this.avg, other.avg) && Objects.equals(this.max, other.max);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MIN.getPreferredName(), this.min);
        builder.field(MAX.getPreferredName(), this.max);
        builder.field(AVG.getPreferredName(), this.avg);
        builder.field(TOTAL.getPreferredName(), this.total);
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), TOTAL);
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), MIN);
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), MAX);
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), AVG);
    }
}

