/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.reindex;

import conductor.org.apache.http.conn.ssl.DefaultHostnameVerifier;
import conductor.org.apache.http.conn.ssl.NoopHostnameVerifier;
import conductor.org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.settings.SecureSetting;
import conductor.org.elasticsearch.common.settings.SecureString;
import conductor.org.elasticsearch.common.settings.Setting;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.ssl.SslConfiguration;
import conductor.org.elasticsearch.common.ssl.SslConfigurationKeys;
import conductor.org.elasticsearch.common.ssl.SslConfigurationLoader;
import conductor.org.elasticsearch.env.Environment;
import conductor.org.elasticsearch.watcher.FileChangesListener;
import conductor.org.elasticsearch.watcher.FileWatcher;
import conductor.org.elasticsearch.watcher.ResourceWatcherService;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

class ReindexSslConfig {
    private static final Map<String, Setting<?>> SETTINGS;
    private static final Map<String, Setting<SecureString>> SECURE_SETTINGS;
    private final SslConfiguration configuration;
    private volatile SSLContext context;

    public static List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.addAll(SETTINGS.values());
        settings.addAll(SECURE_SETTINGS.values());
        return settings;
    }

    ReindexSslConfig(final Settings settings, Environment environment, ResourceWatcherService resourceWatcher) {
        SslConfigurationLoader loader = new SslConfigurationLoader("reindex.ssl."){

            @Override
            protected String getSettingAsString(String key) {
                return settings.get(key);
            }

            @Override
            protected char[] getSecureSetting(String key) {
                Setting setting = (Setting)SECURE_SETTINGS.get(key);
                if (setting == null) {
                    throw new IllegalArgumentException("The secure setting [" + key + "] is not registered");
                }
                return ((SecureString)setting.get(settings)).getChars();
            }

            @Override
            protected List<String> getSettingAsList(String key) throws Exception {
                return settings.getAsList(key);
            }
        };
        this.configuration = loader.load(environment.configFile());
        this.reload();
        FileChangesListener listener = new FileChangesListener(){

            @Override
            public void onFileCreated(Path file) {
                this.onFileChanged(file);
            }

            @Override
            public void onFileDeleted(Path file) {
                this.onFileChanged(file);
            }

            @Override
            public void onFileChanged(Path file) {
                ReindexSslConfig.this.reload();
            }
        };
        for (Path file : this.configuration.getDependentFiles()) {
            try {
                FileWatcher watcher = new FileWatcher(file);
                watcher.addListener(listener);
                resourceWatcher.add(watcher, ResourceWatcherService.Frequency.HIGH);
            }
            catch (IOException e) {
                throw new UncheckedIOException("cannot watch file [" + file + "]", e);
            }
        }
    }

    private void reload() {
        this.context = this.configuration.createSslContext();
    }

    SSLIOSessionStrategy getStrategy() {
        HostnameVerifier hostnameVerifier = this.configuration.getVerificationMode().isHostnameVerificationEnabled() ? new DefaultHostnameVerifier() : new NoopHostnameVerifier();
        String[] protocols = this.configuration.getSupportedProtocols().toArray(Strings.EMPTY_ARRAY);
        String[] cipherSuites = this.configuration.getCipherSuites().toArray(Strings.EMPTY_ARRAY);
        return new SSLIOSessionStrategy(this.context, protocols, cipherSuites, hostnameVerifier);
    }

    static {
        Setting.Property[] properties;
        String settingName;
        SETTINGS = new HashMap();
        SECURE_SETTINGS = new HashMap<String, Setting<SecureString>>();
        Setting.Property[] defaultProperties = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered};
        Setting.Property[] deprecatedProperties = new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.NodeScope, Setting.Property.Filtered};
        for (String key : SslConfigurationKeys.getStringKeys()) {
            settingName = "reindex.ssl." + key;
            properties = SslConfigurationKeys.isDeprecated(key) ? deprecatedProperties : defaultProperties;
            SETTINGS.put(settingName, Setting.simpleString(settingName, properties));
        }
        for (String key : SslConfigurationKeys.getListKeys()) {
            settingName = "reindex.ssl." + key;
            properties = SslConfigurationKeys.isDeprecated(key) ? deprecatedProperties : defaultProperties;
            SETTINGS.put(settingName, Setting.listSetting(settingName, Collections.emptyList(), Function.identity(), properties));
        }
        for (String key : SslConfigurationKeys.getSecureStringKeys()) {
            settingName = "reindex.ssl." + key;
            SECURE_SETTINGS.put(settingName, SecureSetting.secureString(settingName, null, new Setting.Property[0]));
        }
    }
}

