/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.indices.recovery;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.index.seqno.RetentionLeases;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.index.translog.Translog;
import conductor.org.elasticsearch.transport.TransportRequest;
import java.io.IOException;
import java.util.List;

public class RecoveryTranslogOperationsRequest
extends TransportRequest {
    private long recoveryId;
    private ShardId shardId;
    private List<Translog.Operation> operations;
    private int totalTranslogOps = -1;
    private long maxSeenAutoIdTimestampOnPrimary;
    private long maxSeqNoOfUpdatesOrDeletesOnPrimary;
    private RetentionLeases retentionLeases;

    public RecoveryTranslogOperationsRequest() {
    }

    RecoveryTranslogOperationsRequest(long recoveryId, ShardId shardId, List<Translog.Operation> operations, int totalTranslogOps, long maxSeenAutoIdTimestampOnPrimary, long maxSeqNoOfUpdatesOrDeletesOnPrimary, RetentionLeases retentionLeases) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.operations = operations;
        this.totalTranslogOps = totalTranslogOps;
        this.maxSeenAutoIdTimestampOnPrimary = maxSeenAutoIdTimestampOnPrimary;
        this.maxSeqNoOfUpdatesOrDeletesOnPrimary = maxSeqNoOfUpdatesOrDeletesOnPrimary;
        this.retentionLeases = retentionLeases;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public List<Translog.Operation> operations() {
        return this.operations;
    }

    public int totalTranslogOps() {
        return this.totalTranslogOps;
    }

    public long maxSeenAutoIdTimestampOnPrimary() {
        return this.maxSeenAutoIdTimestampOnPrimary;
    }

    public long maxSeqNoOfUpdatesOrDeletesOnPrimary() {
        return this.maxSeqNoOfUpdatesOrDeletesOnPrimary;
    }

    public RetentionLeases retentionLeases() {
        return this.retentionLeases;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = ShardId.readShardId(in);
        this.operations = Translog.readOperations(in, "recovery");
        this.totalTranslogOps = in.readVInt();
        this.maxSeenAutoIdTimestampOnPrimary = in.getVersion().onOrAfter(Version.V_6_5_0) ? in.readZLong() : -1L;
        this.maxSeqNoOfUpdatesOrDeletesOnPrimary = in.getVersion().onOrAfter(Version.V_6_5_0) ? in.readZLong() : -2L;
        this.retentionLeases = in.getVersion().onOrAfter(Version.V_6_7_0) ? new RetentionLeases(in) : RetentionLeases.EMPTY;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        Translog.writeOperations(out, this.operations);
        out.writeVInt(this.totalTranslogOps);
        if (out.getVersion().onOrAfter(Version.V_6_5_0)) {
            out.writeZLong(this.maxSeenAutoIdTimestampOnPrimary);
        }
        if (out.getVersion().onOrAfter(Version.V_6_5_0)) {
            out.writeZLong(this.maxSeqNoOfUpdatesOrDeletesOnPrimary);
        }
        if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
            this.retentionLeases.writeTo(out);
        }
    }
}

