/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.cat;

import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.BytesRestResponse;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.RestStatus;
import conductor.org.elasticsearch.rest.action.cat.AbstractCatAction;
import java.io.IOException;
import java.util.List;

public class RestCatAction
extends BaseRestHandler {
    private static final String CAT = "=^.^=";
    private static final String CAT_NL = "=^.^=\n";
    private final String HELP;

    @Inject
    public RestCatAction(Settings settings, RestController controller, List<AbstractCatAction> catActions) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_cat", this);
        StringBuilder sb = new StringBuilder();
        sb.append(CAT_NL);
        for (AbstractCatAction catAction : catActions) {
            catAction.documentation(sb);
        }
        this.HELP = sb.toString();
    }

    @Override
    public String getName() {
        return "cat_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return channel -> channel.sendResponse(new BytesRestResponse(RestStatus.OK, this.HELP));
    }
}

