/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.script;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.elasticsearch.index.fielddata.ScriptDocValues;
import conductor.org.elasticsearch.script.DeprecationMap;
import conductor.org.elasticsearch.script.ScriptContext;
import conductor.org.elasticsearch.search.lookup.LeafSearchLookup;
import conductor.org.elasticsearch.search.lookup.SearchLookup;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class TermsSetQueryScript {
    public static final String[] PARAMETERS = new String[0];
    public static final ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("terms_set", Factory.class);
    private static final Map<String, String> DEPRECATIONS;
    private final Map<String, Object> params;
    private final LeafSearchLookup leafLookup;

    public TermsSetQueryScript(Map<String, Object> params, SearchLookup lookup, LeafReaderContext leafContext) {
        this.params = new DeprecationMap(params, DEPRECATIONS);
        this.leafLookup = lookup.getLeafSearchLookup(leafContext);
    }

    public Map<String, Object> getParams() {
        this.params.putAll(this.leafLookup.asMap());
        return this.params;
    }

    public Map<String, ScriptDocValues<?>> getDoc() {
        return this.leafLookup.doc();
    }

    public void setDocument(int docid) {
        this.leafLookup.setDocument(docid);
    }

    public long runAsLong() {
        return this.execute().longValue();
    }

    public abstract Number execute();

    static {
        HashMap<String, String> deprecations = new HashMap<String, String>();
        deprecations.put("doc", "Accessing variable [doc] via [params.doc] from within a terms-set-query-script is deprecated in favor of directly accessing [doc].");
        deprecations.put("_doc", "Accessing variable [doc] via [params._doc] from within a terms-set-query-script is deprecated in favor of directly accessing [doc].");
        DEPRECATIONS = Collections.unmodifiableMap(deprecations);
    }

    public static interface Factory {
        public LeafFactory newFactory(Map<String, Object> var1, SearchLookup var2);
    }

    public static interface LeafFactory {
        public TermsSetQueryScript newInstance(LeafReaderContext var1) throws IOException;
    }
}

