/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.metrics.avg;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.elasticsearch.common.lease.Releasables;
import conductor.org.elasticsearch.common.util.BigArrays;
import conductor.org.elasticsearch.common.util.DoubleArray;
import conductor.org.elasticsearch.common.util.LongArray;
import conductor.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollector;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import conductor.org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import conductor.org.elasticsearch.search.aggregations.metrics.avg.InternalAvg;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class AvgAggregator
extends NumericMetricsAggregator.SingleValue {
    final ValuesSource.Numeric valuesSource;
    LongArray counts;
    DoubleArray sums;
    DoubleArray compensations;
    DocValueFormat format;

    public AvgAggregator(String name, ValuesSource.Numeric valuesSource, DocValueFormat formatter, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.format = formatter;
        if (valuesSource != null) {
            BigArrays bigArrays = context.bigArrays();
            this.counts = bigArrays.newLongArray(1L, true);
            this.sums = bigArrays.newDoubleArray(1L, true);
            this.compensations = bigArrays.newDoubleArray(1L, true);
        }
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                AvgAggregator.this.counts = bigArrays.grow(AvgAggregator.this.counts, bucket + 1L);
                AvgAggregator.this.sums = bigArrays.grow(AvgAggregator.this.sums, bucket + 1L);
                AvgAggregator.this.compensations = bigArrays.grow(AvgAggregator.this.compensations, bucket + 1L);
                if (values.advanceExact(doc)) {
                    int valueCount = values.docValueCount();
                    AvgAggregator.this.counts.increment(bucket, valueCount);
                    double sum = AvgAggregator.this.sums.get(bucket);
                    double compensation = AvgAggregator.this.compensations.get(bucket);
                    for (int i = 0; i < valueCount; ++i) {
                        double value = values.nextValue();
                        if (!Double.isFinite(value)) {
                            sum += value;
                            continue;
                        }
                        if (!Double.isFinite(sum)) continue;
                        double corrected = value - compensation;
                        double newSum = sum + corrected;
                        compensation = newSum - sum - corrected;
                        sum = newSum;
                    }
                    AvgAggregator.this.sums.set(bucket, sum);
                    AvgAggregator.this.compensations.set(bucket, compensation);
                }
            }
        };
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.sums.size()) {
            return Double.NaN;
        }
        return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalAvg(this.name, this.sums.get(bucket), this.counts.get(bucket), this.format, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalAvg(this.name, 0.0, 0L, this.format, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.counts, this.sums, this.compensations);
    }
}

