/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.max;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.BucketMetricsPipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.InternalBucketMetricValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MaxBucketPipelineAggregator
extends BucketMetricsPipelineAggregator {
    private List<String> maxBucketKeys;
    private double maxValue;

    protected MaxBucketPipelineAggregator(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, DocValueFormat formatter, Map<String, Object> metaData) {
        super(name, bucketsPaths, gapPolicy, formatter, metaData);
    }

    public MaxBucketPipelineAggregator(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return "max_bucket";
    }

    @Override
    protected void preCollection() {
        this.maxBucketKeys = new ArrayList<String>();
        this.maxValue = Double.NEGATIVE_INFINITY;
    }

    @Override
    protected void collectBucketValue(String bucketKey, Double bucketValue) {
        if (bucketValue > this.maxValue) {
            this.maxBucketKeys.clear();
            this.maxBucketKeys.add(bucketKey);
            this.maxValue = bucketValue;
        } else if (bucketValue.equals(this.maxValue)) {
            this.maxBucketKeys.add(bucketKey);
        }
    }

    @Override
    protected InternalAggregation buildAggregation(List<PipelineAggregator> pipelineAggregators, Map<String, Object> metadata) {
        String[] keys = this.maxBucketKeys.toArray(new String[this.maxBucketKeys.size()]);
        return new InternalBucketMetricValue(this.name(), keys, this.maxValue, this.format, Collections.emptyList(), this.metaData());
    }
}

