/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.transport.netty4;

import conductor.io.netty.channel.Channel;
import conductor.io.netty.util.concurrent.Future;
import conductor.io.netty.util.concurrent.GenericFutureListener;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.common.concurrent.CompletableContext;
import conductor.org.elasticsearch.transport.TcpServerChannel;
import java.net.InetSocketAddress;

public class Netty4TcpServerChannel
implements TcpServerChannel {
    private final Channel channel;
    private final String profile;
    private final CompletableContext<Void> closeContext = new CompletableContext();

    Netty4TcpServerChannel(Channel channel, String profile) {
        this.channel = channel;
        this.profile = profile;
        this.channel.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            if (f.isSuccess()) {
                this.closeContext.complete(null);
            } else {
                Throwable cause = f.cause();
                if (cause instanceof Error) {
                    ExceptionsHelper.maybeDieOnAnotherThread(cause);
                    this.closeContext.completeExceptionally(new Exception(cause));
                } else {
                    this.closeContext.completeExceptionally((Exception)cause);
                }
            }
        }));
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    @Override
    public void close() {
        this.channel.close();
    }

    @Override
    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(ActionListener.toBiConsumer(listener));
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public String toString() {
        return "Netty4TcpChannel{localAddress=" + this.getLocalAddress() + '}';
    }
}

