/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.transport.netty4;

import conductor.io.netty.buffer.ByteBuf;
import conductor.io.netty.buffer.CompositeByteBuf;
import conductor.io.netty.buffer.Unpooled;
import conductor.io.netty.channel.Channel;
import conductor.io.netty.channel.ChannelFuture;
import conductor.io.netty.util.NettyRuntime;
import conductor.io.netty.util.internal.logging.InternalLogger;
import conductor.io.netty.util.internal.logging.InternalLoggerFactory;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.BytesRefIterator;
import conductor.org.elasticsearch.common.Booleans;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.transport.netty4.ByteBufBytesReference;
import conductor.org.elasticsearch.transport.netty4.Netty4InternalESLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

public class Netty4Utils {
    private static AtomicBoolean isAvailableProcessorsSet;

    public static void setup() {
    }

    public static void setAvailableProcessors(int availableProcessors) {
        boolean set = Booleans.parseBoolean(System.getProperty("es.set.netty.runtime.available.processors", "true"));
        if (!set) {
            return;
        }
        if (isAvailableProcessorsSet.compareAndSet(false, true)) {
            NettyRuntime.setAvailableProcessors(availableProcessors);
        } else if (availableProcessors != NettyRuntime.availableProcessors()) {
            String message = String.format(Locale.ROOT, "available processors value [%d] did not match current value [%d]", availableProcessors, NettyRuntime.availableProcessors());
            throw new IllegalStateException(message);
        }
    }

    public static ByteBuf toByteBuf(BytesReference reference) {
        if (reference.length() == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (reference instanceof ByteBufBytesReference) {
            return ((ByteBufBytesReference)reference).toByteBuf();
        }
        BytesRefIterator iterator = reference.iterator();
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>(3);
        try {
            BytesRef slice;
            while ((slice = iterator.next()) != null) {
                buffers.add(Unpooled.wrappedBuffer(slice.bytes, slice.offset, slice.length));
            }
            if (buffers.size() == 1) {
                return (ByteBuf)buffers.get(0);
            }
            CompositeByteBuf composite = Unpooled.compositeBuffer(buffers.size());
            composite.addComponents(true, buffers);
            return composite;
        }
        catch (IOException ex) {
            throw new AssertionError("no IO happens here", ex);
        }
    }

    public static BytesReference toBytesReference(ByteBuf buffer) {
        return Netty4Utils.toBytesReference(buffer, buffer.readableBytes());
    }

    static BytesReference toBytesReference(ByteBuf buffer, int size) {
        return new ByteBufBytesReference(buffer, size);
    }

    public static void closeChannels(Collection<Channel> channels) throws IOException {
        Throwable closingExceptions = null;
        ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>();
        for (Channel channel : channels) {
            try {
                if (channel == null || !channel.isOpen()) continue;
                futures.add(channel.close());
            }
            catch (Exception e) {
                if (closingExceptions == null) {
                    closingExceptions = new IOException("failed to close channels");
                }
                closingExceptions.addSuppressed(e);
            }
        }
        for (ChannelFuture future : futures) {
            future.awaitUninterruptibly();
        }
        if (closingExceptions != null) {
            throw closingExceptions;
        }
    }

    static {
        InternalLoggerFactory.setDefaultFactory(new InternalLoggerFactory(){

            @Override
            public InternalLogger newInstance(String name) {
                return new Netty4InternalESLogger(name);
            }
        });
        isAvailableProcessorsSet = new AtomicBoolean();
    }
}

