/*
 * Decompiled with CFR 0.152.
 */
package conductor.joptsimple.util;

import conductor.joptsimple.ValueConversionException;
import conductor.joptsimple.ValueConverter;
import conductor.joptsimple.internal.Messages;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;

public class InetAddressConverter
implements ValueConverter<InetAddress> {
    @Override
    public InetAddress convert(String value) {
        try {
            return InetAddress.getByName(value);
        }
        catch (UnknownHostException e) {
            throw new ValueConversionException(this.message(value));
        }
    }

    @Override
    public Class<InetAddress> valueType() {
        return InetAddress.class;
    }

    @Override
    public String valuePattern() {
        return null;
    }

    private String message(String value) {
        return Messages.message(Locale.getDefault(), "conductor.joptsimple.ExceptionMessages", InetAddressConverter.class, "message", value);
    }
}

