/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.http.impl.cookie;

import conductor.org.apache.http.annotation.Immutable;
import conductor.org.apache.http.cookie.CommonCookieAttributeHandler;
import conductor.org.apache.http.cookie.Cookie;
import conductor.org.apache.http.cookie.CookieOrigin;
import conductor.org.apache.http.cookie.MalformedCookieException;
import conductor.org.apache.http.cookie.SetCookie;
import conductor.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import conductor.org.apache.http.util.Args;

@Immutable
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

