/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.miscellaneous;

import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.miscellaneous.ConcatenateGraphFilter;
import conductor.org.apache.lucene.analysis.util.TokenFilterFactory;
import java.util.Map;

public class ConcatenateGraphFilterFactory
extends TokenFilterFactory {
    private boolean preserveSep;
    private boolean preservePositionIncrements;
    private int maxGraphExpansions;

    public ConcatenateGraphFilterFactory(Map<String, String> args) {
        super(args);
        this.preserveSep = this.getBoolean(args, "preserveSep", true);
        this.preservePositionIncrements = this.getBoolean(args, "preservePositionIncrements", true);
        this.maxGraphExpansions = this.getInt(args, "maxGraphExpansions", 10000);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new ConcatenateGraphFilter(input, this.preserveSep, this.preservePositionIncrements, this.maxGraphExpansions);
    }
}

