/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.codecs.lucene50;

import conductor.org.apache.lucene.codecs.CodecUtil;
import conductor.org.apache.lucene.codecs.SegmentInfoFormat;
import conductor.org.apache.lucene.index.CorruptIndexException;
import conductor.org.apache.lucene.index.IndexFileNames;
import conductor.org.apache.lucene.index.SegmentInfo;
import conductor.org.apache.lucene.store.ChecksumIndexInput;
import conductor.org.apache.lucene.store.Directory;
import conductor.org.apache.lucene.store.IOContext;
import conductor.org.apache.lucene.util.Version;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

@Deprecated
public class Lucene50SegmentInfoFormat
extends SegmentInfoFormat {
    public static final String SI_EXTENSION = "si";
    static final String CODEC_NAME = "Lucene50SegmentInfo";
    static final int VERSION_SAFE_MAPS = 1;
    static final int VERSION_START = 1;
    static final int VERSION_CURRENT = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentInfo read(Directory dir, String segment, byte[] segmentID, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName(segment, "", SI_EXTENSION);
        try (ChecksumIndexInput input = dir.openChecksumInput(fileName, context);){
            Throwable priorE = null;
            SegmentInfo si = null;
            try {
                CodecUtil.checkIndexHeader(input, CODEC_NAME, 1, 1, segmentID, "");
                Version version = Version.fromBits(input.readInt(), input.readInt(), input.readInt());
                int docCount = input.readInt();
                if (docCount < 0) {
                    throw new CorruptIndexException("invalid docCount: " + docCount, input);
                }
                boolean isCompoundFile = input.readByte() == 1;
                Map<String, String> diagnostics = input.readMapOfStrings();
                Set<String> files = input.readSetOfStrings();
                Map<String, String> attributes = input.readMapOfStrings();
                si = new SegmentInfo(dir, version, null, segment, docCount, isCompoundFile, null, diagnostics, segmentID, attributes, null);
                si.setFiles(files);
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.checkFooter(input, priorE);
            }
            SegmentInfo segmentInfo = si;
            return segmentInfo;
        }
    }

    @Override
    public void write(Directory dir, SegmentInfo si, IOContext ioContext) throws IOException {
        throw new UnsupportedOperationException("this codec can only be used for reading");
    }
}

