/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.document;

import conductor.org.apache.lucene.document.Field;
import conductor.org.apache.lucene.document.FieldType;
import conductor.org.apache.lucene.document.LatLonPointDistanceQuery;
import conductor.org.apache.lucene.document.LatLonPointInPolygonQuery;
import conductor.org.apache.lucene.geo.GeoEncodingUtils;
import conductor.org.apache.lucene.geo.Polygon;
import conductor.org.apache.lucene.index.FieldInfo;
import conductor.org.apache.lucene.search.BooleanClause;
import conductor.org.apache.lucene.search.BooleanQuery;
import conductor.org.apache.lucene.search.ConstantScoreQuery;
import conductor.org.apache.lucene.search.MatchNoDocsQuery;
import conductor.org.apache.lucene.search.PointRangeQuery;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.NumericUtils;

public class LatLonPoint
extends Field {
    public static final int BYTES = 4;
    public static final FieldType TYPE = new FieldType();

    public void setLocationValue(double latitude, double longitude) {
        byte[] bytes;
        if (this.fieldsData == null) {
            bytes = new byte[8];
            this.fieldsData = new BytesRef(bytes);
        } else {
            bytes = ((BytesRef)this.fieldsData).bytes;
        }
        int latitudeEncoded = GeoEncodingUtils.encodeLatitude(latitude);
        int longitudeEncoded = GeoEncodingUtils.encodeLongitude(longitude);
        NumericUtils.intToSortableBytes(latitudeEncoded, bytes, 0);
        NumericUtils.intToSortableBytes(longitudeEncoded, bytes, 4);
    }

    public LatLonPoint(String name, double latitude, double longitude) {
        super(name, TYPE);
        this.setLocationValue(latitude, longitude);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        byte[] bytes = ((BytesRef)this.fieldsData).bytes;
        result.append(GeoEncodingUtils.decodeLatitude(bytes, 0));
        result.append(',');
        result.append(GeoEncodingUtils.decodeLongitude(bytes, 4));
        result.append('>');
        return result.toString();
    }

    private static byte[] encode(double latitude, double longitude) {
        byte[] bytes = new byte[8];
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLatitude(latitude), bytes, 0);
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitude(longitude), bytes, 4);
        return bytes;
    }

    private static byte[] encodeCeil(double latitude, double longitude) {
        byte[] bytes = new byte[8];
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLatitudeCeil(latitude), bytes, 0);
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitudeCeil(longitude), bytes, 4);
        return bytes;
    }

    static void checkCompatible(FieldInfo fieldInfo) {
        if (fieldInfo.getPointDataDimensionCount() != 0 && fieldInfo.getPointDataDimensionCount() != TYPE.pointDataDimensionCount()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with numDims=" + fieldInfo.getPointDataDimensionCount() + " but this point type has numDims=" + TYPE.pointDataDimensionCount() + ", is the field really a LatLonPoint?");
        }
        if (fieldInfo.getPointNumBytes() != 0 && fieldInfo.getPointNumBytes() != TYPE.pointNumBytes()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with bytesPerDim=" + fieldInfo.getPointNumBytes() + " but this point type has bytesPerDim=" + TYPE.pointNumBytes() + ", is the field really a LatLonPoint?");
        }
    }

    public static Query newBoxQuery(String field, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        if (minLatitude == 90.0) {
            return new MatchNoDocsQuery("LatLonPoint.newBoxQuery with minLatitude=90.0");
        }
        if (minLongitude == 180.0) {
            if (maxLongitude == 180.0) {
                return new MatchNoDocsQuery("LatLonPoint.newBoxQuery with minLongitude=maxLongitude=180.0");
            }
            if (maxLongitude < minLongitude) {
                minLongitude = -180.0;
            }
        }
        byte[] lower = LatLonPoint.encodeCeil(minLatitude, minLongitude);
        byte[] upper = LatLonPoint.encode(maxLatitude, maxLongitude);
        if (maxLongitude < minLongitude) {
            BooleanQuery.Builder q = new BooleanQuery.Builder();
            byte[] leftOpen = (byte[])lower.clone();
            NumericUtils.intToSortableBytes(Integer.MIN_VALUE, leftOpen, 4);
            Query left = LatLonPoint.newBoxInternal(field, leftOpen, upper);
            q.add(new BooleanClause(left, BooleanClause.Occur.SHOULD));
            byte[] rightOpen = (byte[])upper.clone();
            NumericUtils.intToSortableBytes(Integer.MAX_VALUE, rightOpen, 4);
            Query right = LatLonPoint.newBoxInternal(field, lower, rightOpen);
            q.add(new BooleanClause(right, BooleanClause.Occur.SHOULD));
            return new ConstantScoreQuery(q.build());
        }
        return LatLonPoint.newBoxInternal(field, lower, upper);
    }

    private static Query newBoxInternal(String field, byte[] min, byte[] max) {
        return new PointRangeQuery(field, min, max, 2){

            @Override
            protected String toString(int dimension, byte[] value) {
                if (dimension == 0) {
                    return Double.toString(GeoEncodingUtils.decodeLatitude(value, 0));
                }
                if (dimension == 1) {
                    return Double.toString(GeoEncodingUtils.decodeLongitude(value, 0));
                }
                throw new AssertionError();
            }
        };
    }

    public static Query newDistanceQuery(String field, double latitude, double longitude, double radiusMeters) {
        return new LatLonPointDistanceQuery(field, latitude, longitude, radiusMeters);
    }

    public static Query newPolygonQuery(String field, Polygon ... polygons) {
        return new LatLonPointInPolygonQuery(field, polygons);
    }

    static {
        TYPE.setDimensions(2, 4);
        TYPE.freeze();
    }
}

