/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.index;

import conductor.org.apache.lucene.index.DocValuesUpdate;
import conductor.org.apache.lucene.index.FieldUpdatesBuffer;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.util.Accountable;
import conductor.org.apache.lucene.util.Counter;
import conductor.org.apache.lucene.util.RamUsageEstimator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class BufferedUpdates
implements Accountable {
    static final int BYTES_PER_DEL_TERM = 9 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 7 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 40;
    static final int BYTES_PER_DEL_DOCID = 2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 4;
    static final int BYTES_PER_DEL_QUERY = 5 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 2 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 + 24;
    final AtomicInteger numTermDeletes = new AtomicInteger();
    final AtomicInteger numFieldUpdates = new AtomicInteger();
    final Map<Term, Integer> deleteTerms = new HashMap<Term, Integer>();
    final Map<Query, Integer> deleteQueries = new HashMap<Query, Integer>();
    final List<Integer> deleteDocIDs = new ArrayList<Integer>();
    final Map<String, FieldUpdatesBuffer> fieldUpdates = new HashMap<String, FieldUpdatesBuffer>();
    public static final Integer MAX_INT = Integer.MAX_VALUE;
    private final Counter bytesUsed = Counter.newCounter(true);
    final Counter fieldUpdatesBytesUsed = Counter.newCounter(true);
    private static final boolean VERBOSE_DELETES = false;
    long gen;
    final String segmentName;

    public BufferedUpdates(String segmentName) {
        this.segmentName = segmentName;
    }

    public String toString() {
        String s = "gen=" + this.gen;
        if (this.numTermDeletes.get() != 0) {
            s = s + " " + this.numTermDeletes.get() + " deleted terms (unique count=" + this.deleteTerms.size() + ")";
        }
        if (this.deleteQueries.size() != 0) {
            s = s + " " + this.deleteQueries.size() + " deleted queries";
        }
        if (this.deleteDocIDs.size() != 0) {
            s = s + " " + this.deleteDocIDs.size() + " deleted docIDs";
        }
        if (this.numFieldUpdates.get() != 0) {
            s = s + " " + this.numFieldUpdates.get() + " field updates";
        }
        if (this.bytesUsed.get() != 0L) {
            s = s + " bytesUsed=" + this.bytesUsed.get();
        }
        return s;
    }

    public void addQuery(Query query, int docIDUpto) {
        Integer current = this.deleteQueries.put(query, docIDUpto);
        if (current == null) {
            this.bytesUsed.addAndGet(BYTES_PER_DEL_QUERY);
        }
    }

    public void addDocID(int docID) {
        this.deleteDocIDs.add(docID);
        this.bytesUsed.addAndGet(BYTES_PER_DEL_DOCID);
    }

    public void addTerm(Term term, int docIDUpto) {
        Integer current = this.deleteTerms.get(term);
        if (current != null && docIDUpto < current) {
            return;
        }
        this.deleteTerms.put(term, docIDUpto);
        this.numTermDeletes.incrementAndGet();
        if (current == null) {
            this.bytesUsed.addAndGet(BYTES_PER_DEL_TERM + term.bytes.length + 2 * term.field().length());
        }
    }

    void addNumericUpdate(DocValuesUpdate.NumericDocValuesUpdate update, int docIDUpto) {
        FieldUpdatesBuffer buffer = this.fieldUpdates.computeIfAbsent(update.field, k -> new FieldUpdatesBuffer(this.fieldUpdatesBytesUsed, update, docIDUpto));
        if (update.hasValue) {
            buffer.addUpdate(update.term, update.getValue(), docIDUpto);
        } else {
            buffer.addNoValue(update.term, docIDUpto);
        }
        this.numFieldUpdates.incrementAndGet();
    }

    void addBinaryUpdate(DocValuesUpdate.BinaryDocValuesUpdate update, int docIDUpto) {
        FieldUpdatesBuffer buffer = this.fieldUpdates.computeIfAbsent(update.field, k -> new FieldUpdatesBuffer(this.fieldUpdatesBytesUsed, update, docIDUpto));
        if (update.hasValue) {
            buffer.addUpdate(update.term, update.getValue(), docIDUpto);
        } else {
            buffer.addNoValue(update.term, docIDUpto);
        }
        this.numFieldUpdates.incrementAndGet();
    }

    void clearDeleteTerms() {
        this.deleteTerms.clear();
        this.numTermDeletes.set(0);
    }

    void clear() {
        this.deleteTerms.clear();
        this.deleteQueries.clear();
        this.deleteDocIDs.clear();
        this.numTermDeletes.set(0);
        this.numFieldUpdates.set(0);
        this.fieldUpdates.clear();
        this.bytesUsed.addAndGet(-this.bytesUsed.get());
        this.fieldUpdatesBytesUsed.addAndGet(-this.fieldUpdatesBytesUsed.get());
    }

    boolean any() {
        return this.deleteTerms.size() > 0 || this.deleteDocIDs.size() > 0 || this.deleteQueries.size() > 0 || this.numFieldUpdates.get() > 0;
    }

    @Override
    public long ramBytesUsed() {
        return this.bytesUsed.get() + this.fieldUpdatesBytesUsed.get();
    }

    void clearDeletedDocIds() {
        this.deleteDocIDs.clear();
        this.bytesUsed.addAndGet(-this.deleteDocIDs.size() * BYTES_PER_DEL_DOCID);
    }
}

