/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.queryparser.flexible.standard.config;

import conductor.org.apache.lucene.queryparser.flexible.core.config.FieldConfig;
import conductor.org.apache.lucene.queryparser.flexible.core.config.FieldConfigListener;
import conductor.org.apache.lucene.queryparser.flexible.core.config.QueryConfigHandler;
import conductor.org.apache.lucene.queryparser.flexible.standard.config.PointsConfig;
import conductor.org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import java.util.Map;

public class PointsConfigListener
implements FieldConfigListener {
    private final QueryConfigHandler config;

    public PointsConfigListener(QueryConfigHandler config) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null!");
        }
        this.config = config;
    }

    @Override
    public void buildFieldConfig(FieldConfig fieldConfig) {
        PointsConfig pointsConfig;
        Map<String, PointsConfig> pointsConfigMap = this.config.get(StandardQueryConfigHandler.ConfigurationKeys.POINTS_CONFIG_MAP);
        if (pointsConfigMap != null && (pointsConfig = pointsConfigMap.get(fieldConfig.getField())) != null) {
            fieldConfig.set(StandardQueryConfigHandler.ConfigurationKeys.POINTS_CONFIG, pointsConfig);
        }
    }
}

